pro fringegif,bincounts
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Run an animation using the frames in bincounts. Bincounts, according to
; standard COBRA format, must have three dimensions, i.e. number of bins,
; channels, and frames.
;
r=size(bincounts)
n_img=r[n_elements(r)-3]
n_chn=r[n_elements(r)-4]
n_bin=r[n_elements(r)-5]
if r[0] eq 3 then b=reform(bincounts,1,n_bin,n_chn,n_img) $
	     else b=bincounts
n_spc=n_elements(b[*,0,0,0])
;
nx=64
ny=64
;
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
;
w=50
loadct,0
for i=0,n_img-1 do begin
	image=bytarr(n_spc*nx,ny)
	for k=0,n_spc-1 do image[k*nx:(k+1)*nx-1,*] $
			=byte(interpolate(reform(b[k,*,*,i]),x,y,/grid) $
				*ravg1(255./max(b[k,*,*,i]),w))
	write_gif,'fringemovie.gif',transpose(image),/multiple
endfor
write_gif,'fringemovie.gif',/close
;
end
