function fringeid,solutions,r0,rn,pt=pt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Function to return nearest integer values for given fringe ID solutions
; from dispersion fits. The ID solutions should have unity spacing, but
; may be offset from zero by non-integer values due to phase offsets.
; The offsets are either computed from all solutions or on a scan-by-scan
; basis (if r0 and rn are defined).
;
; If keyword "pt" is true assume identical fringe ID solutions due to
; phase tracking. This is now the default for intra-scan solutions.
;
if n_elements(pt) eq 0 then pt=1 else pt=pt gt 0
r=size(solutions)
if r[0] eq 1 then s=reform(solutions,1,r[1]) else s=solutions
r=size(s)
new_solutions=s
;
if n_elements(r0) eq 0 or n_elements(rn) eq 0 then begin
	r0=[0]
	rn=[r[2]-1]
endif
;
num_steps=10
step=1.0/num_steps
;
FOR k=0,r[1]-1 DO BEGIN
FOR l=0,n_elements(r0)-1 DO BEGIN
;
count_max=0
i_max=0
for i=0,num_steps+1 do begin
	ymin=-0.5+i*step
	ymax=ymin+step
	index=where(s[k,r0[l]:rn[l]] gt ymin-1 $
		and s[k,r0[l]:rn[l]] lt ymax-1,count1)
	index=where(s[k,r0[l]:rn[l]] gt ymin   $
		and s[k,r0[l]:rn[l]] lt ymax  ,count2)
	index=where(s[k,r0[l]:rn[l]] gt ymin+1 $
		and s[k,r0[l]:rn[l]] lt ymax+1,count3)
	index=where(s[k,r0[l]:rn[l]] gt ymin+2 $
		and s[k,r0[l]:rn[l]] lt ymax+2,count4)
	count=count1+count2+count3+count4
	if count gt count_max then begin
		count_max=count
		i_max=i
	endif
endfor
;
offset=-0.5+i_max*step+step/2
new_s=s[k,r0[l]:rn[l]]-offset
new_offset=avg(new_s-nint(new_s))+offset
if pt then $
   new_solutions[k,r0[l]:rn[l]]=medianve(new_solutions[k,r0[l]:rn[l]]) else $
   new_solutions[k,r0[l]:rn[l]]=nint(s[k,r0[l]:rn[l]]-new_offset)+new_offset
;
ENDFOR
ENDFOR
;
return,reform(new_solutions)
;
end
