pro fringemovie,bincounts
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Run an animation using the frames in bincounts. Bincounts, according to
; standard COBRA format, must have three dimensions, i.e. number of bins,
; channels, and frames.
;
r=size(bincounts)
n_img=r[n_elements(r)-3]
n_chn=r[n_elements(r)-4]
n_bin=r[n_elements(r)-5]
if r[0] eq 3 then b=reform(bincounts,1,n_bin,n_chn,n_img) $
	     else b=bincounts
n_spc=n_elements(b[*,0,0,0])
;
nx=64
ny=64
;
base=widget_base(title='NPOI fringes')
animate=cw_animate(base,nx,ny*n_spc,n_img)
widget_control,/realize,base
;
;x=float((findgen(nx)/nx*n_bin))
;y=float((findgen(ny)/ny*n_chn))
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
;
; for k=0,n_spc-1 do b(k,*,*,*)=bytscl(b(k,*,*,*))
;
w=50
for i=0,n_img-1 do begin
	image=bytarr(n_spc*nx,ny)
;	for k=0,n_spc-1 do image(k*nx:(k+1)*nx-1,*) $
;			=bytscl(interpolate(reform(b(k,*,*,i)),x,y,/grid))
;	for k=0,n_spc-1 do image(k*nx:(k+1)*nx-1,*) $
;			=hist_equal(interpolate(reform(b(k,*,*,i)),x,y,/grid))
	for k=0,n_spc-1 do image[k*nx:(k+1)*nx-1,*] $
			=byte(interpolate(reform(b[k,*,*,i]),x,y,/grid) $
				*ravg1(255./max(b[k,*,*,i]),w))
	cw_animate_load,animate,frame=i, $
		image=transpose(image)
endfor
;
cw_animate_getp,animate,pixmap_vect
cw_animate_run,animate
xmanager,'fringemovie',base,event_handler='fringemovie_event'
;
end
