function fringetriple,c,k1,k2,n
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the complex triple amplitude from fringe frames stored
; in c. The first index in the frames must correspond to the phase bins.
; Use k1 and k2 to select two baselines on the same detector, the third
; will be at -k1-k2 so that the sum k1+k2+k3=0. Average n number of samples.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
k3=-k1-k2
;
; Assume 3 telescopes on this detector
numsid=3
;
result=size(c)
n0=result[1]
norm_factor12=4.0/sinc(float(k1)/n0)^2
norm_factor23=4.0/sinc(float(k2)/n0)^2
norm_factor31=4.0/sinc(float(k3)/n0)^2
norm_factor=sqrt(norm_factor12) $
	   *sqrt(norm_factor23) $
	   *sqrt(norm_factor31) $
	   *(numsid/2.0)^3
;
v1=fringevis(c,k1)
v2=fringevis(c,k2)
v3=fringevis(c,k3)
;
r=fringenphot(c)
;
; Triple product
t=v1*v2*v3
;
return,t
; Poisson bias correction
tb=t-abs(v1)^2-abs(v2)^2-abs(v3)^2+2.0*r
;
return,(add(tb,n)/n)*norm_factor/(add(r,n)/n)^3
;
end
