function fringevis,c,k
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the complex visibilities from fringe frames stored in c.
; The first index in the frames must correspond to the phase bins.
; Use k to select a baseline, if multiple baseline are present.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
c=reform(c)
if n_elements(k) eq 0 then k=1
;
n0=n_elements(c[*,0,0])
n1=n_elements(k)
n2=n_elements(c[0,*,0])
n3=n_elements(c[0,0,*])
;
vis=complexarr(n1,n2,n3)
;
for l=0,n1-1 do begin
for j=0,n0-1 do begin
	p=2*!pi*i_complex*j*k[l]/n0
	vis[l,*,*]=vis[l,*,*]+c[j,*,*]*exp(p)
endfor
endfor
;
return,reform(vis)
;
end
