function fringevissq,b,k,n,normal=normal,error=error, $
	delay=delay,lambda=lambda,numcoh=numcoh,bin8=bin8
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the squared normalized visibility amplitude. Zero if no counts.
; The first index in the frames must correspond to the phase bins.
; Use k to select a baseline, if multiple baseline are present.
; Average incoherently n number of samples.
;
; If given a delay [m] and a number of samples to integrate coherently,
; this function will ...
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(k) eq 0 then k=1
if n_elements(n) eq 0 then n=1l else n=long(n)
;
if n_elements(normal) eq 0 then normal=0 else normal=normal gt 0
if n_elements(numcoh) eq 0 then numcoh=1
if n_elements(bin8) eq 0 then bin8=0
;
b=reform(b)
s=size(b)
n0=s[1]	; Number of bins
;
; Do the coherent integration if requested
if numcoh gt 1 then c=add(rotateframe(fix(b),lambda,delay),numcoh,2) $
	       else c=fix(b)
r=fringenphot(b); *(2./3.)	; if there is incoherent flux
os=replicate({n:transpose(r)},n0)
o=transpose(os.n)/n0
if bin8 then v=fringevis8(b) else v=fringevis(b-o,k)
if n_elements(delay) gt 0 then v=visrotate[v,lambda,delay]
if numcoh gt 1 then begin
	v=add(v,numcoh,1)
	r=add(r,numcoh,1)
endif
nominator=add(abs(v)^2-r,n,s[0]-2,sdev=sdev)/n
rate=add(r,n,s[0]-2)/n
denominator=rate^2
index=where(denominator eq 0,count)
if count gt 0 then denominator[index]=1
v=nominator/denominator
if count gt 0 then v[index]=0
error=(sdev/sqrt(n))/denominator
;
if normal then norm_factor=4.0/sinc(float(k)/n0)^2 $
	  else norm_factor=1.0
;
error=error*norm_factor
;
return,v*norm_factor
;
end
