function ft_dyck,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return floating spectral type defined by M. Dyck (AJ 116, 981),
; ft = -2, ..., 0, ..., 5, 6, ..., 8 for G8, ..., K0, ..., K5, ..., M0, ..., M8
;
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
st=float([-2,0,5,6,8])
ot=float([48,50,55,60,68])
;
return,interpol(st,ot,type)
;
end
