function ft_tabby,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return floating spectral type defined by Boyajan et al. 2012 (ApJ 746, 101),
; ft = 0,  1,  2, ..., 10, 11, 12, ..., 20, 21, 22, ..., 30
; for A0, A1, A2, ..., F0, F1, F2, ..., G0, G1, G2, ..., K0
;
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
st=float([ 0, 1, 2,10,11,12,20,21,22,30])
ot=float([20,21,22,30,31,32,40,41,42,50])
;
return,interpol(st,ot,type)
;
end
