pro funct_gauss,x,a,f
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Gauss fit, a(2) is FWHM, the relationship between sigma and FWHM is:
; sigma=fwhm/(2*sqrt(2*alog(2))) where Gaussian is exp(-(x^2/(2*sigma^2)))
;
exponents=-(2*sqrt(alog(2))*(x-a[1])/(a[2]))^2
index=where(exponents lt -30,count)
if count gt 0 then exponents[index]=-30
f=a[0]*exp(exponents)
;
end
