function gdmap,model,lamda,m_maps,ndim=ndim
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Obsolete
;
; Setup a call to the 1.3 Roche code to get a gravity darkened
; brightness distribution. Returns a map.
; lamda [m]
;
; This function will store equally sized maps in case
; one is called for with parameters already computed
; before.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
common LocalDeane,rochemaps,n_maps,n_dim,rocheparms
;
RAD=180/pi_circle
;
if n_elements(n_dim) eq 0 then n_dim=0
if n_elements(ndim) eq 0 then ndim=128L else ndim=long(ndim)
if ndim ne n_dim then n_maps=0
n_dim=ndim
;
n_maps=0
;
parms=setrocheparms13(model,lamda,0,0)
parmstring=strjoin(string(parms))
;
; If we have one or more maps stored, check whether the one is here
if n_elements(n_maps) eq 0 then n_maps=0
if n_maps gt 0 then begin
	index=where(parmstring eq rocheparms,count)
	if count eq 1 then return,rochemaps[index[0]]
endif
;
rpb=0.0
;
; x=RA runs from -ndim/2 to ndim/2-1
x=float((lindgen(ndim*ndim) mod ndim) - (ndim/2))
x=-x	; RA positive towards East
; y=Dec runs from -ndim/2 to ndim/2-1
y=float((lindgen(ndim*ndim) / ndim) - (ndim/2))
f=reform(fltarr(ndim,ndim),ndim*ndim)
xs=0.0
is=0L
;
status=linknload(!external_lib,'peterson',parms,ndim,x,y,f,xs,is,rpb)
x=reform(x,ndim,ndim)
y=reform(y,ndim,ndim)
f=reform(f,ndim,ndim)
save,x,y,f
;
f=reform(transpose(reform(f,ndim,ndim)),ndim*ndim)
;
; Pixel scale in units of RpB
pfactor=xs/abs(ndim/2-is)
;
; Scale in mas/RpB
rfactor=(rpb/parms[5])*(model.diameter/2)
;
; PA is here the position angle of the major axis, from N over E
angle=(-parms[8]+90)/RAD
rx=(-y*sin(angle)+x*cos(angle))*pfactor*rfactor
ry=(+x*sin(angle)+y*cos(angle))*pfactor*rfactor
map=alloc_map(ndim*ndim,intarr(ndim*ndim),rx,ry,f)
;
; Store the map
if n_elements(m_maps) eq 0 then m_maps=2
if n_maps eq 0 then begin
	rochemaps=replicate(map,m_maps)
	rocheparms=strarr(m_maps)
endif
if n_maps ge m_maps then n_maps=0
rochemaps[n_maps]=map
rocheparms[n_maps]=parmstring
n_maps=n_maps+1
;
return,map
;
end
