function geocentric2equatorial,g_coord,utc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(utc) eq 0 then utc=0.d0
longitude=polarmotion(utc,latitude)
;
e_coord=g_coord
;
e_coord[0,*]=cos(-longitude/RAD)*g_coord[0,*] $
	    -sin(-longitude/RAD)*g_coord[1,*]
e_coord[1,*]=cos(-longitude/RAD)*g_coord[1,*] $
	    +sin(-longitude/RAD)*g_coord[0,*]
;
return,e_coord
;
end
