pro get_2mass,k_max=k_max
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read JHK magnitudes from 2MASS catalog (xdr format).
; If file does not exist, read 2mass_K6.fits and re-create xdr file.
; Note: data found will replace current values!
;
; For applications which limit K, specifiying the limit here is faster.
;
common StarBase,startable,notes
;
file=!oyster_dir+'starbase/2MASS/hip_2mass_K8.xdr'
files=file_search(file)
if strlen(files[0]) eq 0 then begin
	d=mrdfits(!oyster_dir+'starbase/2MASS/2mass_K6.fits',1,h)
	ra_deg=d.raj2000
	dec_deg=d.dej2000
	jmag=d.jmag
	hmag=d.hmag
	kmag=d.kmag
	save,ra_deg,dec_deg,jmag,hmag,kmag,file=file
endif else restore,file
ra_h=ra_deg/15
;
if n_elements(k_max) eq 0 then k_max=max(kmag)
index=where(kmag le k_max,count)
if count eq 0 then return
if count lt n_elements(ra_h) then begin
	ra_h=ra_h[index]
	dec_deg=dec_deg[index]
	jmag=jmag[index]
	hmag=hmag[index]
	kmag=kmag[index]
endif
;
; Adopted positional precision of catalog
min_sep=dblarr(n_elements(startable))
precision=1.0	; ["]
;
index=where(startable.mk gt 0,kmag_count1)
;
for i=0,n_elements(startable)-1 do begin
	sep=winkel(ra_h,dec_deg,startable[i].ra,startable[i].dec)*3600
	min_sep[i]=min(sep)
	if min_sep[i] le precision then begin
		j=where(sep eq min_sep[i])
		startable[i].mj=jmag[j]
		startable[i].mh=hmag[j]
		startable[i].mk=kmag[j]
	endif
endfor
; The histogramm shows that the precision is about 1"
; histograph,min_sep,binsize=0.1,min=0,max=2
;
index=where(startable.mk gt 0,kmag_count2)
if kmag_count2 gt kmag_count1 then $
print,'Number of new 2MASS values found: ',kmag_count2-kmag_count1,'.', $
	format='(a,i7,a)'
;
; save,startable,file=!oyster_dir+'starbase/2MASS/hip_2mass.xdr'
;
;
end
