pro get_amberdata,datatag,stations,starid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; The data tag has the following format: date and time of target obs., then cal.
; 20060218T093131.395_cal_20060218T083634.264
; The will be exanded by adding "_*.fits".
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
date=strmid(datatag,0,4)+'-'+strmid(datatag,4,2)+'-'+strmid(datatag,6,2)
time=hms2h(strmid(datatag,9,2)+':'+strmid(datatag,11,2)+':'+strmid(datatag,13,6)
;
systemid='VLTI/AMBER-MR'
fakedata,stations,starids=starid,times=time*3600
;
; Initialize the third output beam (normally K band)
genconfig.wavelength[*,2]=0
genconfig.wavelengtherr[*,2]=0
genconfig.chanwidth[*,2]=0
genconfig.chanwidtherr[*,2]=0
;
; Flag all data because it will be initialized later
scans.vissqerr=-1
scans.vissqcerr=-1
scans.tripleamperr=-1
scans.tripleampcerr=-1
scans.triplephaseerr=-1
scans.triplephasecerr=-1
;
datafiles=file_search(datatag+'_*.fits')
;
tag='wlen.'
w=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
nc=n_elements(w)
genconfig.numspecchan=nc
genconfig.triplenumchan[2]=nc
genconfig.wavelength[0:nc-1,2]=w
genconfig.wavelengtherr[0:nc-1,2]=1e-9
genconfig.chanwidth[0:nc-1,2]=(max(w)-min(w))/nc
genconfig.chanwidtherr[0:nc-1,2]=1e-9
genconfig.configid=instrument_id(systemid)
;
tag='vis.'
v=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
tag='visErr.'
e=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
for l=0,2 do begin
	scans.vissq[2,0:nc-1,l]=v[l,*]^2
	scans.vissqc[2,0:nc-1,l]=v[l,*]^2
	scans.vissqerr[2,0:nc-1,l]=2*v[l,*]*e[l,*]
	scans.vissqcerr[2,0:nc-1,l]=2*v[l,*]*e[l,*]
endfor
;
tag='clos.'
c=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
scans.triplephase[2,0:nc-1]=c
scans.triplephasec[2,0:nc-1]=c
tag='closErr.'
e=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
scans.triplephaseerr[2,0:nc-1]=e
scans.triplephasecerr[2,0:nc-1]=e
;
tag='flux1.'
f=readfits[datafiles[where(strpos(datafiles,tag) ge 0)]]
scans.photonrate[2,0:nc-1]=f[0,*]
scans.photonrateerr[2,0:nc-1]=0.1
;
calcastrom
;
; Initialization for AMOEBA
freememory
num_config=1
bufferinfo=replicate(nightinfo(),num_config)
geoinfo=replicate(geoparms,num_config)
geninfo=replicate(allocgenconfig(/geninfo),num_config)
geninfo.configid=genconfig.configid
confignum=0
g=geninfo[confignum]
struct_assign,genconfig,g
geninfo[confignum]=g
geoinfo[confignum]=geoparms
storenight
;
end
