pro get_astromcorrgroup,motiongroup,astromgroup
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From INCHWORM output file (.inch), read delay solution #astromgroup
; computed for #motiongroup. User has to load corresponding motion
; group before!
;
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if hds_state() eq 0 then begin
        print,'***Error(GET_ASTROMCORRGROUP): no HDS file open!'
        return
endif
toplevel
;
get_format,format
if format ne 'INCHWORM' then begin
	print,'***Error(GET_ASTROMCORRGROUP): not an INCHWORM file!'
	return
endif
;
if n_elements(motiongroup) eq 0 then motiongroup=1
if n_elements(astromgroup) eq 0 then astromgroup=1
;
get_numastromcorgrp,n
if n lt astromgroup then begin
	print,'***Error(GET_ASTROMCORRGROUP): only ',n,' groups!'
	return
endif
dat_find,'ASTROMCORRGROUP'
astromgroups=intarr(n)
for i=0,n-1 do begin
	dat_cell,1,i+1
	cmp_get0i,'MOTIONGROUP',group
	dat_annul
	if group eq motiongroup then astromgroups[i]=i+1
endfor
index=where(astromgroups ne 0,count)
if count eq 0 then begin
	print,'***Error(GET_ASTROMCORRGROUP): motiongroup not found!'
	return
endif
astromgroups=astromgroups[index]
index=where(astromgroups eq astromgroup,count)
if count eq 0 then begin
	print,'***Error(GET_ASTROMCORRGROUP): astromgroup not found!'
	return
endif
astromgroup0=astromgroups[index[0]]
toplevel
;
; Get info on which siderostat corresponds to which plate
dat_find,'GENCONFIG'
cmp_get0i,'NUMPLATE',numplate
vdim=1L
plateid=intarr(numplate)
dat_find,'PLATE'
for i=1,numplate do begin
	dat_cell,vdim,i
	cmp_get0i,'PLATEEMBEDDED',n
	plateid[i-1]=n
	dat_annul
endfor
dat_annul
dat_annul
nsd=max(plateid)
if nsd lt GenConfig.NumSid then begin
	print,'Warning(GET_ASTROMCORRGROUP): fewer plates than siderostats!'
endif
;
dat_find,'ASTROMCORRGROUP'
dat_cell,vdim,astromgroup0
cmp_get0i,'AVEGROUP',avegroup
dat_annul
dat_annul
;
dat_find,'AVEGROUP'
dat_cell,vdim,avegroup
cmp_get0i,'NUMTIME',numtime
cmp_get1d,'TIME',numtime,MetroTime
MetroTime=MetroTime/1000
dat_annul
dat_annul
;
dat_find,'ASTROMCORRGROUP'
dat_cell,vdim,astromgroup
;
dat_find,'DELAY'
dat_shape,ndim,dims
NumPlate=dims[0]
flag=0
if ndim ne 1 then flag=1
if flag then begin
    print,'***Error(GET_ASTROMCORRGRP): Object DELAY with wrong dimensions'
    toplevel
    return
endif
;
Delay=fltarr(GenConfig.NumSid,numtime)
DelayErr=fltarr(GenConfig.NumSid,numtime)-1
;
pidx=MetroConfig.PlateIdx
for i=1L,NumPlate do begin
	dat_cell,vdim,i
	name1='DATA'
	name2='DATAERR'
	dat_there,name1,reply
	if reply eq 1 and pidx[plateid[i-1]-1] ne -1 then begin
		cmp_get1d,name1,numtime,v
		Delay[pidx[plateid[i-1]-1],*]=v
		cmp_get1d,name2,numtime,v
		index=where(v eq 0,count)
		if count gt 0 then v[index]=-1
        	v[*]=1 ; Until Nick has added error bars
		DelayErr[pidx[plateid[i-1]-1],*]=v
	endif
	dat_annul
endfor
dat_annul
;
dat_find,'SIDCTERM'
dat_shape,ndim,dims
NumPlate=dims[0]
flag=0
if ndim ne 1 then flag=1
if flag then begin
    print,'***Error(GET_ASTROMCORGRP): Object SIDCTERM with wrong dimensions'
    toplevel
    return
endif
;
SidCTerm=fltarr(GenConfig.NumSid,numtime)
SidCTermErr=fltarr(GenConfig.NumSid,numtime)-1
;
for i=1L,nsd do begin
	dat_cell,vdim,i
	name1='DATA'
	name2='DATAERR'
	dat_there,name1,reply
	if reply eq 1 and pidx[plateid[i-1]-1] ne -1 then begin
		cmp_get1d,name1,numtime,v
		SidCTerm[pidx[plateid[i-1]-1],*]=v
		cmp_get1d,name2,numtime,v
		index=where(v eq 0,count)
		if count gt 0 then v[index]=-1
        	v[*]=1 ; Until Nick has added error bars
		SidCTermErr[pidx[plateid[i-1]-1],*]=v
	endif
	dat_annul
endfor
;
MetroPath=Delay+SidCTerm
sign=fltarr(nsd,numtime)+1
index=where(DelayErr lt 0 or SidCTermErr lt 0,count)
if count gt 0 then sign[index]=-1
MetroPathErr=sqrt(DelayErr^2+SidCTermErr^2)*sign
;
toplevel
print,'AstromCorr group loaded.'
;
end
