pro get_avegroup,avegroup
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From INCHWORM output file (.inch), read avegroup. Such a group is
; characterized by a specific integration time.
;
; Note the conversion factor for motor angles:
; angle [deg] = motor counts * 360e-8.
;
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if hds_state() eq 0 then begin
        print,'***Error(GET_AVEGROUP): no HDS file open!'
        return
endif
toplevel
;
if n_elements(avegroup) eq 0 then avegroup=1
;
get_format,format
if format ne 'INCHWORM' then begin
	print,'***Error(GET_AVEGROUP): not an INCHWORM file!'
	return
endif
;
if checkdata([1,8]) ne 0 then return
get_datum,datum
;
; If SidConId exists, NAT data are in the right place
dat_find,'GENCONFIG'
dat_find,'INPUTBEAM'
dat_there,'SIDCONID',reply
if reply eq 1 then use_sidcon=0 else use_sidcon=1
dat_annul
dat_annul
;
; Get info on which siderostat corresponds to which plate
dat_find,'GENCONFIG'
cmp_get0i,'NUMPLATE',numplate
vdim=1L
plateid=intarr(numplate)
dat_find,'PLATE'
for i=1,numplate do begin
	dat_cell,vdim,i
	cmp_get0i,'PLATEEMBEDDED',n
	plateid[i-1]=n
	dat_annul
endfor
dat_annul
dat_annul
nsd=max(plateid)
if nsd lt GenConfig.NumSid then begin
	print,'Warning(GET_AVEGROUP): fewer plates than siderostats!'
endif
;
dat_find,'AVEGROUP'
dat_cell,vdim,avegroup
cmp_get0i,'NUMTIME',numtime
cmp_get1d,'TIME',numtime,MetroTime
MetroTime=MetroTime/1000
if nextdate(datum) eq date then MetroTime=MetroTime-86400
if nextdate(date) eq datum then MetroTime=MetroTime+86400
;
MotorAngle=dblarr(2,GenConfig.NumSid,numtime)
MotorAngleErr=dblarr(2,GenConfig.NumSid,numtime)
;
dat_find,'MOTORDATA'
dat_shape,ndim,dims
;
for i=1L,GenConfig.NumSid do begin
k=where(GenConfig.SidConId eq i)
; Beginning in 2003, CONSTRICTOR puts the data into the right places
; if long(strmid(date,0,4)) ge 2003 then k=i-1
if not use_sidcon then k=i-1
for j=1L,2 do begin
	dat_cell,ndim,[i,j]
	dat_there,'DATA',reply
	if reply then begin
		cmp_get1d,'DATA',numtime,v
		MotorAngle[j-1,k,*]=v*360e-8
		cmp_get1d,'DATAERR',numtime,v
		index=where(v eq 0,count)
		if count gt 0 then v[index]=360e8
		MotorAngleErr[j-1,k,*]=v*360e-8
	endif
	index=where(MotorAngle[0,k,*] eq 0 and MotorAngle[1,k,*] eq 0,count)
	if count gt 0 then begin
		MotorAngleErr[0,k,index]=-360e-8
		MotorAngleErr[1,k,index]=-360e-8
	endif
	dat_annul
endfor
endfor
;
numscan=n_elements(ScanTable)
Sol0=lonarr(numscan)
SolN=lonarr(numscan)
Jscan=ScanTable.Iscan
for i=0,numscan-1 do begin
	index=where(MetroTime ge ScanTable[i].StartTime $
		and MetroTime le ScanTable[i].StopTime,count)
	if count gt 0 then begin
		Sol0[i]=index[0]
		SolN[i]=index[count-1]
	endif else begin
		Sol0[i]=-1
		SolN[i]=-1
	endelse
endfor
;
; Initialize other variables for this avegroup
ParX=fltarr(GenConfig.NumSid,numtime)
ParXErr=fltarr(GenConfig.NumSid,numtime)-1
ParY=fltarr(GenConfig.NumSid,numtime)
ParYErr=fltarr(GenConfig.NumSid,numtime)-1
ParZ=fltarr(GenConfig.NumSid,numtime)
ParZErr=fltarr(GenConfig.NumSid,numtime)-1
;
MetroPath=fltarr(GenConfig.NumSid,numtime)
MetroPathErr=fltarr(GenConfig.NumSid,numtime)-1
;
toplevel
print,'Ave group loaded.'
;
end
