pro get_bgscans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if hds_state() eq 0 then begin
	print,'***Error(GET_BGSCANS): no HDS file open!'
	return
endif
;
if checkdata([8]) ne 0 then return
;
get_numbgscan,numscan
if numscan gt 0 then begin
; 	Allocate scan items
	MS=max(GenConfig.NumSpecChan)
	s=allocbgscan(GenConfig.NumOutBeam,MS)
	bgscans=replicate(s,numscan)
	time=dblarr(numscan,/nozero)
;
	vdim=1L
	ndim=0L
	maxdim=7L
	dims=lonarr(maxdim)
;
	dat_find,'BGSCANDATA'
	cmp_get1d,'TIME',numscan,time
; 	Convert to seconds
	if numscan gt 1 then bgscans.time=time/1000 $
			else bgscans.time=time[0]/1000
;
	dat_find,'OUTPUTBEAM'
	for j=0L,GenConfig.NumOutBeam-1 do begin
		dat_cell,vdim,j+1
		dat_find,'RATE'
   		dat_shape,ndim,dims
		icheck=0
   		if ndim ne 2 then icheck=1
   		if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
   		if dims[1] ne numscan  then icheck=1
 		if icheck eq 1 then begin
 			print,'***Error(GET_BGSCANS): found Rate dimensions ', $
 		  		'inconsistent with declarations!'
 		   	return
 		endif
		a=fltarr(1,dims[0],dims[1],/nozero)
		dat_getnr,ndim,dims,aa
		a[0,*,*]=aa
		bgscans.Rate[j,0:dims[0]-1]=a
		dat_annul
;		dat_find,'RATEERR'
;		dat_getnr,ndim,dims,aa
;		a(0,*,*)=aa
;		bgscans.RateErr(j,0:dims(0)-1)=a
;		dat_annul
		e=sqrt(abs(a)/1000)
		index=where(a le 0,count)
		if count gt 0 then e[index]=-1
		bgscans.RateErr[j,0:dims[0]-1]=e
		dat_annul
	endfor
	dat_annul
	dat_annul
	print,'Background data loaded.'
endif else print,'Warning(GET_BGSCANS): no BG data!'
;
end
