pro get_bgtable
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Create background scan table.
;
common Tables,ScanTable,BGTable,StationTable
;
if hds_state() eq 0 then begin
	print,'***Error(GET_BGTABLE): no HDS file open!'
	return
endif
toplevel
;
get_numbgscan,numscan
if numscan gt 0 then begin
	Iscan=lindgen(numscan)+1
;
	dat_find,'BGSCANDATA'
	cmp_get1i,'SCANID',numscan,ScanId
	cmp_get1d,'TIME',numscan,Time & Time=Time/1000
	cmp_get1d,'RA',numscan,Ra
	cmp_get1d,'DEC',numscan,Dec
	dat_annul
;
	BGTable=build_bgtable(Iscan,ScanId,Time,Ra,Dec)
;
	print,'Backgroundtable created.'
endif else print,'Warning(GET_BGTABLE): no BG data!'
;
end
