pro get_bias,bias
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([8]) ne 0 then return
maxBaseline=max(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1])
;
Bias=0
if hds_state() eq 1 then begin
	toplevel
	dat_find,'GenConfig'
	dat_find,'OutputBeam'
	name='BIAS'
	dat_there,name,reply
	if reply eq 1 then begin
		cmp_shape,name,ndim,dims
		cmp_getnd,name,ndim,dims,Bias
		print,'Bias read from HDS file.'
	endif
	dat_annul
endif
if total(abs(Bias)) eq 0 and SystemId eq 'NPOI' then begin
	parsedate,checkdate(),y,m,d
	biasfile=!oyster_dir+'npoi/biasbase.xdr'
	if total(strlen(file_search(biasfile))) ne 0 then begin
		restore,!oyster_dir+'npoi/biasbase.xdr'
		config=database.config
		parsedate,database.date,y0,m0,d0
		jd0=julian(y0,m0,d0) & si=sort(jd0) & jd0=jd0[si]
		index=where(jd0 le julian(y,m,d),count)
		if count gt 0 then begin
			index=where(jd0[count-1] eq julian(y0,m0,d0))
			Bias=database[index].bias
			GenConfig.config=config[index]
			print,'Bias read from ',database[index].date,' in data base.'
		endif
	endif else count=0
	if count eq 0 then begin
;	Based on 1998-07-14
	if julian(y,m,d) le julian(1999,12,31) then begin
	bdate='1998-07-14'
	Bias=transpose(reform([ $
	  [0.0899023,    0.167974,   0.0988566], $
	  [ 0.138122,    0.120250,    0.105369], $
	  [0.0853347,    0.128038,    0.108213], $
	  [0.0624924,    0.211609,   0.0632165], $
	  [ 0.111021,    0.110428,   0.0874976], $
	  [ 0.142510,    0.206276,   0.0679928], $
	  [0.0194781,   0.0885834,   0.0524271], $
	  [0.0583806,    0.110569,   0.0439823], $
	  [0.0667493,   0.0356532,   0.0646192], $
	  [0.0495556,   0.0542092,   0.0713222], $
	  [0.0757267,   0.0280108,   0.0711093], $
	  [0.0711259,   0.0437314,   0.0641880], $
	  [0.0651558,   0.0576786,   0.0598149], $
	  [0.0758625,   0.0294509,   0.0632960], $
	  [ 0.118095,   0.0377117,   0.0878602], $
	  [0.0985272,   0.0670980,    0.125428], $
	  [0.0592213,    0.121473,    0.162831], $
	  [0.0699054,    0.277655,   0.0521088], $
	  [0.0806393,    0.143614,   0.0768278], $
	  [0.0682241,    0.135369,    0.113044], $
	  [0.0818196,    0.243253,    0.289125], $
	  [0.0938335,    0.154664,     0.00000], $
	  [0.0718071,    0.130604,     0.00000], $
	  [0.0705534,    0.144733,     0      ], $
	  [0.0768314,    0.209294,    0.111030], $
	  [ 0.269136,    0.269348,   0.0987174], $
	  [  0.00000,    0.142651,   0.0929011], $
	  [0.0723583,    0.162545,   0.0498033], $
	  [0.0737517,     0.00000,     0.00000], $
	  [0.0647651,     0.00000,     0.00000], $
	  [0.0616645,     0.00000,     0.00000], $
	  [0.0605535,     0.00000,     0.00000],[fltarr(3,32)-1]],3,32,1,2))
	endif
;	Based on 2000-07-22
	if julian(y,m,d) ge julian(2000,7,21) then begin
	bdate='2000-07-22'
	Bias=reform(transpose( $
	      [[[   1.69177,    0.478276,   0.0796059], $
  		[  0.919373,    0.481476,    0.347879], $
  		[  0.302004,    0.370480,    0.158449], $
  		[  0.412788,    0.529370,    0.316756], $
  		[  0.561398,    0.274930,    0.750652], $
  		[  0.382302,    0.271530,    0.720391], $
  		[  0.428420,    0.180083,    0.127880], $
  		[   1.63636,    0.120278,    0.178796], $
  		[  0.269416,    0.529102,    0.341602], $
  		[  0.604920,    0.285504,    0.635365], $
  		[  0.415821,    0.240923,    0.499662], $
  		[  0.256408,    0.217809,     0.00000], $
  		[  0.289473,    0.312165,    0.230929], $
  		[  0.338644,    0.405591,    0.648344], $
  		[  0.199341,    0.233833,     2.45829], $
  		[  0.560465,    0.254822,     1.77624], $
  		[  0.213516,    0.629395,   0.0509382], $
  		[  0.182308,    0.411363,    0.260507], $
  		[  0.193218,    0.640461,    0.243130], $
  		[  0.164621,     1.24305,    0.220178], $
  		[  0.511859,     1.48610,    0.415244], $
  		[   1.26748,    0.137225,    0.342397], $
  		[  0.338130,    0.433200,   0.0746368], $
  		[  0.329144,    0.560588,   0.0979971], $
  		[  0.835394,    0.132254,    0.268300], $
  		[  0.355850,    0.469768,     6.89633], $
  		[  0.322371,    0.396236,   0.0951167], $
  		[  0.240567,    0.883198,    0.301117], $
  		[   0.00000,    0.489537,    0.130460], $
  		[   0.00000,     0.00000,    0.124764], $
  		[   0.00000,    0.453756,    0.106889], $
  		[   0.00000,    0.398829,    0.403420]], $
 	       [[  -1.25808,    -1.05920,   -0.869705], $
  		[  -1.09746,   -0.996786,   -0.981200], $
  		[  -1.07957,   -0.931071,   -0.878819], $
  		[  -1.15658,    -1.00325,    -1.01269], $
  		[  -1.06493,    -1.10437,    -1.09944], $
  		[  -1.02319,    -1.02622,    -1.06814], $
  		[  -1.04508,   -0.940143,    -1.15401], $
  		[  -1.10566,   -0.916836,   -0.914486], $
  		[  -1.00148,    -1.02493,   -0.985655], $
  		[  -1.03988,   -0.952320,    -1.12783], $
  		[  -1.20093,   -0.817902,    -1.10659], $
  		[ -0.974683,   -0.909846,     0.00000], $
  		[  -1.13678,   -0.938783,    -1.01431], $
  		[  -1.02520,   -0.935511,    -1.08890], $
  		[  -1.02507,   -0.833425,    -1.21337], $
  		[  -1.20829,    -1.00098,    -1.12522], $
  		[ -0.859674,    -1.00461,   -0.757941], $
  		[  -1.21178,   -0.866884,    -1.01431], $
  		[  -1.21244,    -1.01319,    -1.00573], $
  		[ -0.732162,   -0.962564,   -0.974857], $
  		[  -1.26526,   -0.932072,    -1.21793], $
  		[  -1.01042,   -0.818386,   -0.948013], $
  		[  -1.00903,    -1.03310,   -0.732898], $
  		[  -1.06772,   -0.967852,    -1.01297], $
  		[  -1.07422,   -0.872275,   -0.888332], $
  		[  -1.01493,   -0.945318,    -1.05196], $
  		[ -0.961374,   -0.961688,   -0.784427], $
  		[ -0.916645,   -0.831189,   -0.861407], $
  		[   0.00000,   -0.901701,    -1.71984], $
  		[   0.00000,     0.00000,   -0.823252], $
  		[   0.00000,   -0.972456,   -0.589181], $
  		[   0.00000,   -0.507537,   -0.830297]]]),2,1,32,3)
	endif
;	Based on 2000-09-20
	if julian(y,m,d) ge julian(2000,7,26) then begin
	bdate='2000-09-20'
	Bias=reform(transpose( $
	 [[[ 2.34974,    0.463135,    0.549775], $
	   [ 1.98768,    0.702093,    0.534707], $
	   [0.376229,    0.708216,    0.286134], $
	   [0.380634,    0.804916,    0.501519], $
	   [ 1.13563,    0.299085,    0.994746], $
	   [0.660806,    0.355672,    0.923398], $
	   [0.921255,    0.154945,   0.0534789], $
	   [ 2.47268,    0.230520,    0.275792], $
	   [0.375058,    0.689234,    0.538494], $
	   [ 1.06977,    0.453575,    0.590598], $
	   [0.201151,    0.481969,    0.820368], $
	   [0.550956,    0.262498,     1.87802], $
	   [0.109338,    0.444762,    0.275550], $
	   [0.229670,    0.604727,    0.676104], $
	   [0.306275,    0.394604,     2.55712], $
	   [0.391842,    0.365425,     1.92808], $
	   [0.252809,    0.709528,   0.0555068], $
	   [0.241256,    0.443538,    0.329732], $
	   [0.335814,    0.700353,    0.407276], $
	   [0.291203,     1.65236,    0.312362], $
	   [0.295144,     1.93693,    0.321580], $
	   [ 1.50629,    0.189681,    0.473475], $
	   [0.310947,    0.489772,    0.123695], $
	   [0.260669,    0.602627,   0.0825925], $
	   [0.834961,    0.140548,    0.278869], $
	   [0.364395,    0.491624,     9.71347], $
	   [0.335162,    0.411833,    0.124889], $
	   [0.254994,     1.04750,    0.347032], $
	   [ 0.00000,    0.531638,    0.142471], $
	   [ 0.00000,    0.535319,    0.112205], $
	   [ 0.00000,    0.480229,   0.0833645], $
	   [ 0.00000,    0.262069,    0.458110]], $
	  [[-1.34646,    -1.05240,    -1.54923], $
	   [-1.31814,    -1.12604,    -1.12693], $
	   [-1.17054,    -1.10487,    -1.10097], $
	   [-1.12462,    -1.15640,    -1.17742], $
	   [-1.23921,    -1.21548,    -1.17914], $
	   [-1.17260,    -1.09474,    -1.14134], $
	   [-1.29162,   -0.882525,   -0.912641], $
	   [-1.22885,    -1.14704,    -1.08366], $
	   [-1.11320,    -1.09484,    -1.10998], $
	   [-1.19563,    -1.11445,    -1.10278], $
	  [-0.979332,    -1.03008,    -1.19085], $
	  [ -1.21475,    -1.07988,   -0.486431], $
	  [-0.895925,    -1.06897,    -1.12273], $
	  [-0.964488,    -1.11071,    -1.11081], $
	  [ -1.24854,    -1.05966,    -1.21917], $
	  [ -1.14140,    -1.25711,    -1.16141], $
	  [ -1.00234,    -1.01273,   -0.845195], $
	  [ -1.42969,   -0.960407,    -1.12477], $
	  [ -1.41212,    -1.02264,    -1.36548], $
	  [-0.995011,    -1.06182,    -1.24190], $
	  [ -1.04056,    -1.02183,    -1.12542], $
	  [ -1.10609,    -1.02245,    -1.14857], $
	  [ -1.04787,    -1.05178,    -1.25820], $
	  [-0.940433,    -1.00779,    -1.05952], $
	  [ -1.08760,    -1.03038,   -0.908170], $
	  [ -1.00389,   -0.966287,    -1.20345], $
	  [-0.977306,   -0.966761,    -1.31777], $
	  [ -1.03555,    -1.02206,    -1.00028], $
	  [  0.00000,    -1.02635,    -1.27341], $
	  [  0.00000,   -0.741966,   -0.915020], $
	  [  0.00000,    -1.03946,   -0.916895], $
	  [  0.00000,    -1.01027,    -1.05683]]]),2,1,32,3)
	endif
	print,'Bias coefficients used are from '+bdate+'.'
	endif
endif
;
if n_params() eq 0 then GenConfig.V2Bias[*,0:maxBaseline-1,*,*] $
		                   =Bias[*,0:maxBaseline-1,*,*]
;
end
