pro get_bincounts,beam
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; To be used to read BinCounts for a specified output beam from a raw
; data file. Assume time and delay data have already been read using
; get_rawdata. Therefore, the RawData common block variables hold the
; sub-scan data of one interferometer (i.e. output beam/spectrometer), plus
; time and laser data for the whole night.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(beam) eq 0 then begin
	print,'Error(GET_BINCOUNTS): no beam specified!'
	return
endif
ob=beam-1
outputbeam=beam
;
if hds_state() eq 0 then begin
	print,'***Error(GET_BINCOUNTS): no HDS file open!'
	return
endif
toplevel
;
if checkdata([8]) ne 0 then return
parsedate,date,y,m,d
jd=julian(y,m,d)
;
numsid=GenConfig.NumSid
numout=GenConfig.NumOutBeam
maxchn=max(GenConfig.NumSpecChan)
maxbas=max(GenConfig.NumBaseline)
numrec=long(total(ScanTable.NumPoint))
;
num_scans=1
dat_find,'SCANDATA'
cmp_get1i,'numrec',1,nrec
dat_find,'RAWDATA'
FOR i=0,num_scans-1 DO BEGIN
	vdim=1L
	dat_cell,vdim,i+1
;
	cmp_get1d,'time',nrec[i],time
	Raw0=where(TimeStamp eq time[0]) & Raw0=Raw0[0] > 0
	RawN=where(TimeStamp eq time[nrec[i]-1]) & RawN=RawN[0]
;
	dat_find,'OutputBeam'
	dat_cell,1,beam
	dat_there,'BinCounts',reply
	if not reply then return
	get_object,'BinCounts',BinCounts
	NumBin=n_elements(BinCounts[*,0])
	if NumBin ne GenConfig.NumBin then $
		BinCounts=add(BinCounts,NumBin/GenConfig.NumBin)
;	Correct channel offsets between 1998-01-29 and 2001-09-24
	if NumBin eq 8 and jd lt julian(2001,9,25) and beam eq 2 then begin
		bincounts[*,8:13,*]=bincounts[*,8:13,*]-4
		bincounts[*,14:15,*]=bincounts[*,14:15,*]-6
	endif
	dat_annul
;
ENDFOR
;
toplevel
; quack
;
print,'BinCounts loaded.'
;
end
