pro get_borde,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read AMBER calibrator list, "borde.hdn", compiled by Borde et al.
; HDN.xdr can be updated (update=1) since not all stars in the Borde list are
; also in SKYCAT used by OYSTER for HDN starids.
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/borde.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	lines=''
	status=dc_read_fixed(!oyster_dir+'starbase/borde.hdn',lines, $
		/col,resize=[1],format='(a800)',ignore=['!'])
	n=n_elements(lines)
	hd=lonarr(n)
	hr=intarr(n)
	stars=strarr(n)
	ra=dblarr(n)
	dec=dblarr(n)
	pmra=dblarr(n)
	pmdec=dblarr(n)
	plx=fltarr(n)
	eplx=fltarr(n)
	spectrum=strarr(n)
	ldd=fltarr(n)
	ldde=fltarr(n)
	teff=fltarr(n)
	logg=fltarr(n)
	mb=fltarr(n)
	mv=fltarr(n)
	mj=fltarr(n)
	mh=fltarr(n)
	mk=fltarr(n)
;
	for i=0,n-1 do begin
		words=nameparse(lines[i],'|')
		hd[i]=long(words[0])
		hr[i]=fix(words[1]) > 0
		stars[i]=words[2]
		ra[i]=hms2h(strmid(words[3],1,12))
		d=strcompress(words[4],/remove_all)
		if strlen(d) eq 10 then d=' '+d
		dec[i]=abs(double(strmid(d,0,3)))+double(strmid(d,3,2))/60+double(strmid(d,5,6
		if float(strmid(d,0,3)) lt 0 then dec[i]=-dec[i]
		pmra[i]=((float(words[5])/3600)/15*100)/cos(dec[i]*!pi/180)
		pmdec[i]=(float(words[6])/3600)*100
		if strlen(strcompress(words[7],/remove_all)) gt 0 then begin
			plx[i]=float(words[7])
			eplx=float(words[8])
		endif
		spectrum[i]=words[9]
		ldd[i]=float(words[10])
		ldde[i]=float(words[11])
		teff[i]=float(words[12])
		logg[i]=float(words[13])
		mb[i]=float(words[25])
		mv[i]=float(words[26])
		mj[i]=float(words[27])
		mh[i]=float(words[29])
		mk[i]=float(words[31])
	endfor
;
	for i=0L,count-1 do begin
		j=where(hd eq hdn[i],j_count)
		if j_count gt 0 then begin
			startable[index[i]].ra=ra[j]
			startable[index[i]].dec=dec[j]
			startable[index[i]].pmra=pmra[j]
			startable[index[i]].pmdec=pmdec[j]
			startable[index[i]].px=plx[j]
			startable[index[i]].pxe=eplx[j]
			startable[index[i]].spectrum=spectrum[j]
			startable[index[i]].diameter=ldd[j]
;			startable(index(i)).diametere=ldde(j)
			startable[index[i]].teff=teff[j]
			startable[index[i]].logg=logg[j]
			startable[index[i]].mv=mv[j]
			startable[index[i]].bv=mb[j]-mv[j]
			startable[index[i]].mj=mj[j]
			startable[index[i]].mh=mh[j]
			startable[index[i]].mk=mk[j]
			startable[index[i]].bflag='C'
		endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameter values found: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_BORDE): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
startable.spectrum=strcompress(startable.spectrum,/remove_all)
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
