pro get_calvin,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read the CALVIN calibrator list calvin.hdn and if not available, read the
; original list calibrators.calvin compiled by Richichi et al. and reformat.
; These stars have name problems with coordinates: pi.02uma_B02/HD  73108b,
; 45eri_B02, 45eri,epspsc, 19ari,nu2cma,30gem,v448car,6leo,v337car,51hya,110vir,
; 2lup,59sgr,kapgru.
;
; Diameters are either LD for instr=MIDI, or UDK for VINCI and AMBER
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
; The input file is derived from calibrators.calvin (export file)
calvinhdn=file_search(!oyster_dir+'starbase/calvin.hdn')
;
IF strlen(calvinhdn[0]) eq 0 THEN BEGIN
; We need to read the export file, reformat, and write to calvin.hdn
name=''
sp=''
lc=''
model=''
instr=''
ref=''
h=0.
q=0.
pmra=0.d0
status=dc_read_free(!oyster_dir+'starbase/calibrators.calvin',name, $
	rah,ram,ras,si,dd,dm,ds,epoch, $
	v,r,j,h,k,l,m,n,q,sp,lc,flag,d,de,model, $
	teff,logg,mass,vsini,vrad,pi,epi,pmra,pmdec,z,instr,ref, $
	/col,ignore=['#'])
nn=n_elements(name)
index=where(finite(v) eq 0,count) & if count gt 0 then v[index]=100
index=where(finite(j) eq 0,count) & if count gt 0 then j[index]=100
index=where(finite(h) eq 0,count) & if count gt 0 then h[index]=100
index=where(finite(k) eq 0,count) & if count gt 0 then k[index]=100
index=where(finite(n) eq 0,count) & if count gt 0 then n[index]=100
index=where(abs(pmra) gt 1e6,count) & if count gt 0 then pmra[index]=0
index=where(abs(pmdec) gt 1e6,count) & if count gt 0 then pmdec[index]=0
index=where(abs(v) gt 1e6,count) & if count gt 0 then v[index]=100
index=where(abs(j) gt 1e6,count) & if count gt 0 then j[index]=100
index=where(abs(h) gt 1e6,count) & if count gt 0 then h[index]=100
index=where(abs(k) gt 1e6,count) & if count gt 0 then k[index]=100
index=where(abs(n) gt 1e6,count) & if count gt 0 then n[index]=100
index=where(teff lt 0,count) & if count gt 0 then teff[index]=0
index=where(logg lt 0,count) & if count gt 0 then logg[index]=0
index=where(pi lt 0,count) & if count gt 0 then pi[index]=0
index=where(epi lt 0,count) & if count gt 0 then epi[index]=0
;
ui=uniq(name)
nn=n_elements(ui)
name=name[ui]
;
starids=strarr(nn)
hdn=lonarr(nn)
;
for i=0,nn-1 do begin
	words=nameparse(name[i],'_')
	if strpos(words[0],'hd') ge 0 then begin
		hdn[i]=long(strmid(words[0],2,6))
		starids[i]='HDN'+string(hdn[i],format='(i6.6)')
	endif
	if strpos(words[0],'hr') ge 0 then begin
		hdn[i]=cri(long(strmid(words[0],2,6)),'bsc-hdn')
		if hdn[i] ne 0 then starids[i]='HDN'+string(hdn[i],format='(i6.6)')
	endif
endfor
;
; Stars without HD or HR number so far: lookup in SIMBAD
ra=float(rah)+float(ram)/60+float(ras)/3600
dec=float(si)*(float(dd)+float(dm)/60+float(ds)/3600)
objid='OBJ'+esoid(ra,dec) & objid=objid[ui]
;
for i=0,nn-1 do begin
	if hdn[i] eq 0 then begin
		star=cri_simbad(objid[i])
		print,'For name ',name[i],' found star ',star
		hd=cri_simbad(star,table)
		if abs(ra[ui[i]]-table.ra)*15.*3600. gt 0.2 or $
		   abs(dec[ui[i]]-table.dec)*3600. gt 0.2 then begin
			print,'***Error: misindentification!'
			return
		endif
		words=nameparse(hd)
		if words[0] eq 'HD' then begin
			hdn[i]=long(words[1])
			starids[i]='HDN'+string(hdn[i],format='(i6.6)')
		endif
	endif
endfor
openw,unit,!oyster_dir+'starbase/calvin.hdn',/get_lun
for i=0,nn-1 do begin
if hdn[i] ne 0 then begin
	printf,unit,hdn[i],ra[ui[i]],dec[ui[i]],pmra[ui[i]],pmdec[ui[i]], $
		pi[ui[i]],epi[ui[i]], $
		v[ui[i]],j[ui[i]],h[ui[i]],k[ui[i]],n[ui[i]],d[ui[i]],de[ui[i]], $
		sp[ui[i]],name[i],instr[ui[i]], $
		format='(i6,13(2x,f12.5),3(2x,a10))'
endif
endfor
free_lun,unit
ENDIF
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/calvin.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	spectrum=''
	name=''
	instr=''
	status=dc_read_free(!oyster_dir+'starbase/calvin.hdn', $
		hd,ra,dec,pmra,pmdec,plx,eplx,mv,mj,mh,mk,mn,ldd,eldd, $
		spectrum,name,instr,/col, $
		ignore=['!'])
	model=strarr(n_elements(instr))
	index=where(instr eq 'VINCI' or instr eq 'AMBER_K',count)
	if count gt 0 then model[index]='UDK'
	index=where(instr eq 'MIDI',count)
	if count gt 0 then model[index]='LD'
;
	for i=0L,count-1 do begin
		j=where(hd eq hdn[i],j_count) & j=j[0]
		if j_count gt 0 then begin
			startable[index[i]].ra=ra[j]
			startable[index[i]].dec=dec[j]
			startable[index[i]].pmra=((pmra[j]/1000)/15)*100 $
				/cos(dec[j]*!pi/180)
			startable[index[i]].pmdec=pmdec[j]/10
			startable[index[i]].px=plx[j]
			startable[index[i]].pxe=eplx[j]
			startable[index[i]].spectrum=spectrum[j]
			startable[index[i]].diameter=ldd[j]
			startable[index[i]].mv=mv[j]
			startable[index[i]].mj=mj[j]
			startable[index[i]].mh=mh[j]
			startable[index[i]].mk=mk[j]
			startable[index[i]].f12=n2jy(mn[j])
			startable[index[i]].model=model[j]
			startable[index[i]].bflag='C'
		endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameter values found: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_CALVIN): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
