pro get_cat,cat
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Restore external dynamical catalogs saved in XDR format. In these secondary
; catalogs, just as in the primary catalogs, the starid has a unique catalog
; identifier, e.g. 'USR' or 'CAL'.
;
common StarBase,StarTable,Notes
;
case cat of
	'USR':catfile='usr/USR.xdr'
	'BBC':catfile='bbc/BBC.xdr'
	'HDN':catfile='hdn/HDN.xdr'
	'CAL':catfile='cal/CAL.xdr'
	else:
endcase
;
; Restore catfile to StarTable
if n_elements(catfile) eq 0 then print,'***Error(GET_CAT): unknown catalog!' $
			    else restore,!catalogs_dir+catfile
;
; Make sure the restored table is compatible with the startable format
table=startable
create_startable,table.starid
for i=0,n_elements(table)-1 do begin
	t=startable[i]
	struct_assign,table[i],t
	startable[i]=t
endfor
;
end
