pro get_crossindex,level
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From the Hipparcos input catalog, the FKV and BSC catalogs, compile and save
; crossindex tables.
; Also prepare non-direct and derived cross indices.
;
; Level 0: do only derived
; Level 1: do full set
;
common StarBase,StarTable,Notes
;
if n_elements(level) eq 0 then level=0
if level eq 0 then goto,derived
;
status=linknload(!external_lib,'crossindex')
if status ne 0 then return
;
hic=0L
fkv=0
bsc=0
hdn=0L
sao=0L
status=dc_read_free('crossindex.dat',hic,fkv,bsc,hdn,sao,/col)
spawn,'rm -f crossindex.dat'
hic=long(hic)
fkv=long(fkv)
bsc=long(bsc)
hdn=long(hdn)
sao=long(sao)
;
; Create "direct" cross indices
create_cri,'fkv-hic',fkv,hic
create_cri,'hdn-fkv',hdn,fkv
create_cri,'hdn-bsc',hdn,bsc
create_cri,'sao-hic',sao,hic
create_cri,'hdn-hic',hdn,hic
create_cri,'hdn-sao',hdn,sao
create_cri,'fkv-sao',fkv,sao
;
; Create "non-direct" cross indices
id1=fkv[where(fkv ne 0)]
id2=cri(cri(id1,'fkv-hdn'),'hdn-bsc')
index=where(id2 gt 0)
create_cri,'fkv-bsc',id1[index],id2[index]
id1=bsc[where(bsc ne 0)]
id2=cri(cri(id1,'bsc-hdn'),'hdn-hic')
index=where(id2 gt 0)
create_cri,'bsc-hic',id1[index],id2[index]
;
; Create derived cross indices
derived:
; get_bat
; Now replaced by SB9 (The ninth catalogue of spectroscopic binary orbits",
; Pourbaix D., Tokovinin A.A., Batten A.H., Fekel F.C., Hartkopf W.I.,
; Levato H., Morrell N.I., Torres G., Udry S., 2004, Astronomy and
; Astrophysics, 424, 727-732.
get_sb9
index=where(startable.bat ne 0 and startable.hdn ne 0)
bat=startable[index].bat
hdn=startable[index].hdn
create_cri,'bat-hdn',bat,hdn
bsc=cri(hdn,'hdn-bsc')
index=where(bsc gt 0)
create_cri,'bat-bsc',bat[index],bsc[index]
fkv=cri(hdn,'hdn-fkv')
index=where(fkv gt 0)
create_cri,'bat-fkv',bat[index],fkv[index]
;
get_fln
index=where(startable.fln ne 0 and startable.hdn ne 0)
fln=startable[index].fln
hdn=startable[index].hdn
create_cri,'fln-hdn',fln,hdn
;
end
