pro get_diameter,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read diameters in starbase/diameter.bsc.
; Note: data found will replace current values!
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update bsc.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/diameter.bsc',bsc,/col, $
		ignore=['!'])
	get_startable,'BSC'+string(bsc,format='(i4.4)')
	uindex=where(startable.bsc eq 0)
	startable.bsc=bsc
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.bsc ne 0,count)
if count gt 0 then begin
	diameter=startable[index].diameter
	zerospacing=startable[index].zerospacing
	a0=startable[index].a0
	a1=startable[index].a1
	a2=startable[index].a2
	bflag=startable[index].bflag
	bsc=startable[index].bsc
	n=0
	d=0.0
	z=0.0
	a_0=0.0
	a_1=0.0
	a_2=0.0
	c=''
	status=dc_read_free(!oyster_dir+'starbase/diameter.bsc', $
		n,d,z,a_0,a_1,a_2,c,/col,resize=[1,2,3,4,5,6,7],ignore=['!'])
;
	for i=0,count-1 do begin
		j=where(n eq bsc[i],j_count)
		if j_count gt 0 then begin
			diameter[i]=d[j[0]]
			zerospacing[i]=z[j[0]]
			a0[i]=a_0[j[0]]
			a1[i]=a_1[j[0]]/1e3
			a2[i]=a_2[j[0]]/1e6
			bflag[i]=c[j[0]]
		endif
	endfor
	startable[index].diameter=diameter
	startable[index].zerospacing=zerospacing
	startable[index].a0=a0
	startable[index].a1=a1
	startable[index].a2=a2
	startable[index].bflag=bflag
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameters added: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_DIAMETER): No stars with BSC name found!'
;
end
