function get_ellipse,p,a1,a2,e_parms,mode,phase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; e_parms=fltarr(5)
; 0: center x-coordinate
; 1: center y-coordinate
; 2: major axis
; 3: minor axis
; 4: position angle
;
c=[(a1[0]+a2[0])/2,(a1[1]+a2[1])/2]
ca1=a1-c
asqr=total(ca1^2)
if mode eq 1 then begin
        cp=c-p
        cpsqr=total(cp^2)
        xsqr=total(ca1*cp)^2/asqr
        ysqr=cpsqr-xsqr
        bsqr=ysqr/(1-xsqr/asqr)
        b=sqrt(bsqr)
endif else b=e_parms[3]
;
pa=atan(ca1[0],ca1[1])
r=ellipse(sqrt(asqr),b,phase-pa)
x=r*sin(phase)+c[0]
y=r*cos(phase)+c[1]
;
e_parms[0:1]=c
e_parms[2]=sqrt(asqr)
e_parms[3]=b
e_parms[4]=pa
;
return,[[x],[y]]
end
