pro get_feh
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Cayrel de Strobel (1985) [Fe/H] data in
; catalogs/npoi/feh.hdn.
; Note: data will replace current non-zero values!
;
common StarBase,startable,notes
;
index=where(startable.feh ne +100,feh_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	feh=startable[index].feh
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/feh.hdn', $
		n,fe_h,/col,ignore=['!'])
;
	for i=0L,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			feh[i]=fe_h[j[0]]
		endif
	endfor
	startable[index].feh=feh
;
	index=where(startable.feh ne +100,feh_count2)
	print,'Number of new [Fe/H] values found: ',feh_count2-feh_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_FEH): No stars with HDN name found!'
;
end
