pro get_hic
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire Hipparcos Input Catalog into reduced NPOI StarTable.
; Note, that we cannot load the complete table due to limited memory!
;
common StarBase,StarTable,Notes
;
; With this n, you need 7 catalog reads to fill in the reduced table.
n=16887L
;
for i=0,6 do begin
	get_startable,'HIC'+stringl(lindgen(n)+1+i*n,format='(i6.6)')
	table_n=extract_npoi()
	if n_elements(table) ne 0 then begin
		table=merge_npoi(table,table_n)
	endif else table=table_n
endfor
index= $
  where(strlen(strcompress(strmid(table.starid,0,3),/remove_all)) eq 0,count)
if count gt 0 then table=table[index]
;
StarTable=table
;
end
