pro get_hip,gaia=gaia
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire Hipparcos Output Catalog, 120416 entries.
; Optionally, replace HIP parallaxes with GAIA parallaxes (81867 avail.)
;
common StarBase,StarTable,Notes
;
hipfile=!catalogs_dir+'hipparcos/hip_main.xdr'
if keyword_set(gaia) then hipfile=!catalogs_dir+'hipparcos/hip_gaia.xdr'
result=file_search(hipfile)
IF strlen(result[0]) ne 0 THEN restore,hipfile $
ELSE BEGIN
;
get_startable,'HIP'+stringl(lindgen(120416)+1,format='(i6.6)')
StarTable.starid='HIP'+stringl(StarTable.hic,format='(i6.6)')
;
if keyword_set(gaia) then begin
	d=read_csv(!catalogs_dir+'gaia/hip-gaia.csv',record_start=1)
	hip=d.field1
	hip_plx=d.field2/1d3	; convert mas to arcsec
	hip_plxe=d.field3/1d3
	gaia_plx=d.field4/1d3
	gaia_plxe=d.field5/1d3
	sep_gaia_hip=d.field6
	med_sep_gaia_hip=median(sep_gaia_hip)
	if max(sep_gaia_hip) gt 3*med_sep_gaia_hip then begin
		print,'Warning: possible misidentification(s):'
		i=where(sep_gaia_hip gt 3*med_sep_gaia_hip)
		print,hip[i]
	endif
	index=whereequal(startable.hic,hip)
	for i=0l,n_elements(index)-1 do begin
		j=where(hip eq startable[index[i]].hic) & j=j[0]
		startable[index[i]].hic=hip[j]
		startable[index[i]].px=gaia_plx[j]
		startable[index[i]].pxe=gaia_plxe[j]
	endfor
endif
;
save,StarTable,file=hipfile
;
ENDELSE
;
end
