pro get_i12
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read un-corrected 12 micron IRAS fluxes.
;
common StarBase,startable,notes
;
index=where(startable.f12 ne 0,f12_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	f12=startable[index].f12
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/IRAS/iras.hdn', $
		n,f_12,/col,ignore=['!'])
;
	for i=0l,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			f12[i]=f_12[j[0]]
		endif
	endfor
	startable[index].f12=f12
;
	index=where(startable.f12 ne 0,f12_count2)
	print,'Number of new F12 values found: ',f12_count2-f12_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_I12): No stars with HDN name found!'
;
end
