pro get_inchgroup,motiongroup,astromgroup
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure loads a motion group and the corresponding astromcorrgroup
; if it has been created with INCHWORM. The group number refers to the
; motiongroup simply because this group represents the primary metrology
; solution for the pixot (x,y,z) coordinates, whereas the astromcorrgroup
; represents the delay correction based on a specific motiongroup. Both groups
; contain a pointer to a corresponding avegroup which contains the timestamps
; and other data relevant for this integration.
;
if hds_state() eq 0 then begin
        print,'***Error(GET_INCHGROUP): no HDS file open!'
        return
endif
;
if checkdata([1,21]) ne 0 then return
;
if n_elements(motiongroup) eq 0 then motiongroup=1
if n_elements(astromgroup) eq 0 then astromgroup=1
;
get_motiongroup,motiongroup
get_astromcorrgroup,motiongroup,astromgroup
;
end
