pro get_iras
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given an IRAS ID, look up the flux in a table extracted from the IRAS catalog
; and update the startable with all 12 micron fluxes found.
;
; The IRAS ID (iras_cat_id) has the form 12345-1234 or 12345+1234
; In StarTable, the prefix is 'IRAS'
;
common StarBase,startable,notes
;
; Look for IRAS XDR file, and if not found, create it for faster reading
file=!oyster_dir+'starbase/IRAS/iras.xdr'
files=file_search(file)
if strlen(files[0]) eq 0 then begin
;	Initialize variable type
	iras_cat_id=''
	f12=0.
	result=dc_read_free( $
		!oyster_dir+'starbase/IRAS/iras.iras',/col, $
		iras_cat_id,f12,ignore=['!'])
	save,iras_cat_id,f12,file=file
endif else restore,file
;
iras_id=irasid(startable.ra,startable.dec)
;
; Setup for counting new values found
index=where(startable.f12 gt 0,f12_count1)
;
for i=0,n_elements(startable)-1 do begin
	j=where(iras_cat_id eq iras_id[i] $
	       or iras_cat_id eq startable[i].name,count)
	if count eq 1 then startable[i].f12=f12[j]
endfor
;
index=where(startable.f12 gt 0,f12_count2)
print,'Number of new F12 values found: ',f12_count2-f12_count1,'.', $
	format='(a,i7,a)'
;
end
