pro get_jhk_hic
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read JHK magnitudes from HIP based list of IRSA data
; Version using jhk_hip.hic, based on get_hip.
;
; The data were obtained from http://irsa.ipac.caltech.edu/cgi-bin/Gator/nph-dd,
; using the following list (head only, all HIP which have HDN):
; \EQUINOX = 'J2000.0'
; |   ra           |   dec         |  major |
; |   double       |   double      | double |
;    0.00089920883       1.0890088     1.0
;     0.0042646079      -19.498840     1.0
;     0.0050243058       38.859279     1.0
;     0.0086292358      -51.893546     1.0
;     0.0099734379      -40.591202     1.0
;
common StarBase,startable,notes
;
; cntr_u	Counter
; dist_x	Distance in arcseconds from target position
; pang_x	Position angle for offset from target position
; ra_u		Right ascension of target
; dec_u		Declination of target
; major_u	Major axis of target ellipse
; ra		Right ascension of IR point source
; dec		Declination of IR point source
; clon
; clat
; err_maj	Major axis of 1-sigma error ellipse
; err_min	Minor axis of 1-sigma error ellipse
; err_ang	Position angle of error ellipse
; designation	Sexagesimal coordinate designation of target
; j_m 		J band selected "default" magnitude
; j_cmsig	Corrected J band photometric uncertainty
; j_msigcom	Combined (total) J band photometric uncertainty
; j_snr		H band "scan" signal-to-noise ratio
; h_m 		H band selected "default" magnitude
; h_cmsig	Corrected H band photometric uncertainty
; h_msigcom	Combined (total) H band photometric uncertainty
; h_snr		H band "scan" signal-to-noise ratio
; k_m 		K band selected "default" magnitude
; k_cmsig	Corrected K band photometric uncertainty
; k_msigcom	Combined (total) K band photometric uncertainty
; k_snr		K band "scan" signal-to-noise ratio
; ph_qual	Flag indicating photometric quality of source
; rd_flg	Source of JHK "default"mags (AKA "read flag")
; bl_flg	Indicates # JHK components fit simultaneously to source
; cc_flg	Indicates JHK artifact contamination and/or confusion
; ndet		Number of >3-sig. ap. mag measurements, # possible (jjhhkk)
; gal_contam	Flag indicating if src is contaminated by extended source
; mp_flg	Src is positionally associated with an asteroid, comet, etc.
;
index=where(startable.mj ne +100,mj_count1)
;
index=where(startable.hic ne 0,count)
if count gt 0 then begin
;
mj=startable[index].mj
mh=startable[index].mh
mk=startable[index].mk
hic=startable[index].hic
;
xdr_file=file_search(!oyster_dir+'starbase/jhk_hip.xdr') & xdr_file=xdr_file[0]
if strlen(xdr_file) eq 0 then begin
status=dc_read_free(!oyster_dir+'starbase/jhk_hip.hic',n,/col,ignore=['!'])
designation=''
status=dc_read_free(!oyster_dir+'starbase/jhk_hip.dat',cntr_u,dist_x,pang_x, $
	ra_u,dec_u,major_u,ra,dec,clon,clat,err_maj,err_min,err_ang,designation, $
	j_m,j_cmsig,j_msigcom,j_snr, $
	h_m,h_cmsig,h_msigcom,h_snr, $
	k_m,k_cmsig,k_msigcom,k_snr, $
	ignore=['!'],null=' 0  ',/col)
n=n[cntr_u-1]
save,n,h_m,j_m,k_m,filename=!oyster_dir+'starbase/jhk_hip.xdr'
endif else restore,xdr_file
;
for i=0L,count-1 do begin
	j=where(n eq hic[i],j_count)
	if j_count gt 0 then begin
		mj[i]=j_m[j[0]]
		mh[i]=h_m[j[0]]
		mk[i]=k_m[j[0]]
	endif
endfor
startable[index].mj=mj
startable[index].mh=mh
startable[index].mk=mk
;
index=where(startable.mj ne +100,mj_count2)
print,'Number of new JHK values found: ',mj_count2-mj_count1,'.', $
	format='(a,i5,a)'
;
endif else print,'Warning(GET_JHK): No stars with HIC name found!'
;
end
