pro get_jhk_sky
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read JHK magnitudes from BSC based list of IRSA data
; Version using jhk_sky.hdn, based on get_sky.
;
common StarBase,startable,notes
;
; cntr_u	Counter
; dist_x	Distance in arcseconds from target position
; pang_x	Position angle for offset from target position
; ra_u		Right ascension of target
; dec_u		Declination of target
; major_u	Major axis of target ellipse
; ra		Right ascension of IR point source
; dec		Declination of IR point source
; err_maj	Major axis of 1-sigma error ellipse
; err_min	Minor axis of 1-sigma error ellipse
; err_ang	Position angle of error ellipse
; designation	Sexagesimal coordinate designation of target
; j_m 		J band selected "default" magnitude
; j_cmsig	Corrected J band photometric uncertainty
; j_msigcom	Combined (total) J band photometric uncertainty
; j_snr		H band "scan" signal-to-noise ratio
; h_m 		H band selected "default" magnitude
; h_cmsig	Corrected H band photometric uncertainty
; h_msigcom	Combined (total) H band photometric uncertainty
; h_snr		H band "scan" signal-to-noise ratio
; k_m 		K band selected "default" magnitude
; k_cmsig	Corrected K band photometric uncertainty
; k_msigcom	Combined (total) K band photometric uncertainty
; k_snr		K band "scan" signal-to-noise ratio
; ph_qual	Flag indicating photometric quality of source
; rd_flg	Source of JHK "default"mags (AKA "read flag")
; bl_flg	Indicates # JHK components fit simultaneously to source
; cc_flg	Indicates JHK artifact contamination and/or confusion
; ndet		Number of >3-sig. ap. mag measurements, # possible (jjhhkk)
; gal_contam	Flag indicating if src is contaminated by extended source
; mp_flg	Src is positionally associated with an asteroid, comet, etc.
;
index=where(startable.mj ne +100,mj_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
;
mj=startable[index].mj
mh=startable[index].mh
mk=startable[index].mk
hdn=startable[index].hdn
;
xdr_file=file_search(!oyster_dir+'starbase/jhk_sky.xdr') & xdr_file=xdr_file[0]
if strlen(xdr_file) eq 0 then begin
status=dc_read_free(!oyster_dir+'starbase/jhk_sky.hdn',n,/col,ignore=['!'])
designation=''
status=dc_read_free(!oyster_dir+'starbase/jhk_sky.dat',cntr_u,dist_x,pang_x, $
	ra_u,dec_u,major_u,ra,dec, $
	j_m,j_cmsig,h_m,h_cmsig,k_m,k_cmsig, $
	rd_flg, $
	ignore=['!'],null=' 0  ',/col)
n=n[cntr_u-1]
save,n,h_m,j_m,k_m,filename=!oyster_dir+'starbase/jhk_sky.xdr'
endif else restore,xdr_file
;
	for i=0L,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			mj[i]=j_m[j[0]]
			mh[i]=h_m[j[0]]
			mk[i]=k_m[j[0]]
		endif
	endfor
	startable[index].mj=mj
	startable[index].mh=mh
	startable[index].mk=mk
;
	index=where(startable.mj ne +100,mj_count2)
	print,'Number of new JHK values found: ',mj_count2-mj_count1,'.', $
		format='(a,i5,a)'
;
endif else print,'Warning(GET_JHK): No stars with HDN name found!'
;
end
