pro get_jp11,quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Johnson (1966) UBVRIJKLMN from Vizier in catalogs/npoi/jp11.hdn.
; If file does not exist, execute helper function to read jp11.dat.
; Note: data found will replace current values!
;
common StarBase,startable,notes
;
files=file_search(!oyster_dir+'starbase/jp11.hdn') & files=files[0]
if strlen(files) eq 0 then begin
	status=dc_read_free(!oyster_dir+'starbase/jp11.dat',/col,ignore=['!'], $
		rah,ram,ras,dd,dm,ds,lid,mu,mb,mv,mr,mi,mj,mk,ml,mm,mn,mh)
	ra=float(rah)+float(ram)/60+float(ras)/3600
	dec=signof(dd)*(float(abs(dd))+float(dm)/60+float(ds)/3600)
	index=where(ra lt 24 and mj lt 99 and mh lt 99 and mk lt 99,count)
	hdn=lonarr(count)
	get_sky
	jp11_ra=startable.ra
	jp11_dec=startable.dec
	for i=0L,count-1 do begin
		jp11_ra[*]=ra[index[i]]
		jp11_dec[*]=dec[index[i]]
		w=winkel(jp11_ra,jp11_dec,startable.ra,startable.dec)
		j=where(w eq min(w))
		if w[j] lt 2.0/(3600) then hdn[i]=startable[j].hdn
	endfor
	openw,unit,'jp11.hdn',/get_lun
	for i=0L,count-1 do if hdn[i] gt 0 then $
		printf,unit,hdn[i],mj[index[i]],mh[index[i]],mk[index[i]]
	free_lun,unit
endif
;
index=where(startable.mj ne +100,mj_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	mj=startable[index].mj
	mh=startable[index].mh
	mk=startable[index].mk
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/jp11.hdn', $
		n,m_j,m_h,m_k,/col,ignore=['!'])
;
	for i=0L,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			mj[i]=m_j[j[0]]
			mh[i]=m_h[j[0]]
			mk[i]=m_k[j[0]]
		endif
	endfor
	startable[index].mj=mj
	startable[index].mh=mh
	startable[index].mk=mk
;
	index=where(startable.mj ne +100,mj_count2)
	if not keyword_set(quiet) then $
	print,'Number of new JHK values found: ',mj_count2-mj_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_JP11): No stars with HDN name found!'
;
end
