pro get_jsdc,init=init,best=best,badcal=badcal
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read latest JMMC calibrator catalog, jsdc_YYYY_MM_DD.fits.
; (currently at VizieR catalog II/346)
;
; Diameters are LD.
;
; II/346    JMMC Stellar Diameters Catalogue - JSDC. Version 2  (Bourges+, 2017)
; ==============================================================================
; An all-sky catalogue of computed star diameters.
;     Bourges L., Mella G., Lafrasse S., Duvert G., Chelli A., Le Bouquin J.-B.,
;     Delfosse X., Chesneau O.
;    <ASP Conference Series, Vol. 485, p.223 (2014)>
;    =2014ASPC..485..223B
;    =2017yCat.2346....0B
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. Keyword update not available since JSDC is based on HIP IDs.
; If best=1, select only the highest grade calibrators.
;
; If keyword badcal is set, filter out stars in file badcal.xml.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
; Read entire catalog if no startable exists or init=1
if n_elements(startable) eq 0 or init then begin
	init=1
	d=read_jsdc()
	create_startable,d.name
	index_hdn=where(strmid(startable.starid,0,3) eq 'HDN')
	index_hip=where(strmid(startable.starid,0,3) eq 'HIP')
	startable[index_hdn].hdn=long(strmid(startable[index_hdn].starid,3,6))
	startable[index_hip].hic=long(strmid(startable[index_hip].starid,3,6))
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
; Currently, we can only handle HDN and HIC IDs
index=where(startable.hic ne 0 or startable.hdn ne 0,count)
; index_hdn=where(startable.hdn ne 0,count_hdn)
; index_hic=where(startable.hic ne 0,count_hic)
;
if count gt 0 then begin
	hic=startable[index].hic
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
;	Read FITS file
	d=read_jsdc() & n=n_elements(d)
	hdn_jsdc=lonarr(n)
	hip_jsdc=lonarr(n)
	i=where(strmid(d.name,0,2) eq 'HD')
	hdn_jsdc[i]=long(strmid(d[i].name,3,6))
	i=where(strmid(d.name,0,3) eq 'HIP')
	hip_jsdc[i]=long(strmid(d[i].name,3,6))
;
;	Check for tag names
	tags=tag_names(d)
	index=where(strpos(tags,'SPTYPE') ge 0)
	index=index[0]
	print,'Using SPTYPE from '+tags[index]
	sptype=d.(index)
;
;	Read required fields
;	sptype=d.sptype
	ldd_chi2=d.e_ldd*0+1
	av=d.vmag*0
	if keyword_set(best) then begin
		index_best=where(av lt 1 and ldd_chi2 lt 3)
		d=d[index_best]
		sptype=sptype[index_best]
		ldd_chi2=ldd_chi2[index_best]
		av=av[index_best]
	endif
	ra=d.raj2000/15
	dec=d.dej2000
;	pmra=d.pmra
;	pmdec=d.pmdec
;	plx=d.plx
;	e_plx=d.e_plx
	bmag=d.bmag
	vmag=d.vmag
	rmag=d.rmag
	imag=d.imag
	jmag=d.jmag
	hmag=d.hmag
	kmag=d.kmag
	ldd=d.ldd
	e_ldd=d.e_ldd
;	teff=d.teff_sptype
;	logg=d.logg_sptype
	ub=limbcoeff(d.ldd/d.uddb)
	uv=limbcoeff(d.ldd/d.uddv)
	ur=limbcoeff(d.ldd/d.uddr)
	ui=limbcoeff(d.ldd/d.uddi)
	uj=limbcoeff(d.ldd/d.uddj)
	uh=limbcoeff(d.ldd/d.uddh)
	uk=limbcoeff(d.ldd/d.uddk)
	un=limbcoeff(d.ldd/d.uddn)
;	http://en.wikipedia.org/wiki/Photometric_system
	wl=[0.445,0.551,0.658,0.806,1.220,1.630,2.190,9.67]
	tm=transpose([[ub],[uv],[ur],[ui],[uj],[uh],[uk],[un]])
	n=n_elements(d)
	a0=fltarr(n)
	a1=fltarr(n)
	a2=fltarr(n)
	for i=0L,n-1 do begin
		r=poly_fit(wl,tm[*,i],2)
		a0[i]=r[0]
		a1[i]=r[1]
		a2[i]=r[2]
	endfor
;
;	Transfer data to StarTable
	for i=0L,count-1 do begin
		if init then begin
			i=lindgen(n_elements(startable))
			j=lindgen(n_elements(d))
			j_count=1
		endif else begin
			j=where((hip_jsdc eq hic[i] and hic[i] ne 0) $
			     or (hdn_jsdc eq hdn[i] and hdn[i] ne 0),j_count)
			j=j[0]
		endelse
		if j_count ge 1 then begin
			startable[i].ra=ra[j]
			startable[i].dec=dec[j]
;			startable(i).pmra=((pmra(j)/10)/15) $
;					 /cos(dec(j)*!pi/180)
;			startable(i).pmdec=pmdec(j)/10
;			startable(i).px=plx(j)
;			startable(i).pxe=e_plx(j)
			startable[i].diameter=ldd[j]
;			startable(i).diametere=e_ldd(j)
			startable[i].a0=a0[j]
			startable[i].a1=a1[j]/1e3
			startable[i].a2=a2[j]/1e6
			startable[i].spectrum=sptype[j]
;			startable(i).logg=logg(j)
;			startable(i).teff=teff(j)
			startable[i].bv=bmag[j]-vmag[j]
			startable[i].mv=vmag[j]
			startable[i].ri=rmag[j]-imag[j]
			startable[i].mj=jmag[j]
			startable[i].mh=hmag[j]
			startable[i].mk=kmag[j]
			startable[i].bflag='C'
		endif
		if init then break
	endfor
	index=where(startable.hic ne 0,ic)
	if ic gt 0 then begin
	hdn=cri(startable[index].hic,'hic-hdn')
	jndex=where(hdn ge 0,jc)
	if jc gt 0 then $
	startable[index[jndex]].hdn=hdn[jndex]
	endif
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameters added: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i6,a)'
;
endif else print,'Warning(GET_JSDC): No stars with HIP name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse,startable.spectrum
;
if n_elements(starids) ne 0 then startable.starid=starids
;
if keyword_set(badcal) then begin
	dec_rad=startable.dec*!pi/180
	ra_deg=startable.ra*15
;	badcal.xml: http://apps.jmmc.fr/badcal/show.jsp?type=all&display=simple
;	https://www.astro.umd.edu/~eshaya/PDS/PDS/read_votable.pro
	r=read_votable[!oyster_dir+'starbase/badcal.xml']
	bad_index=intarr(n_elements(startable))
	for i=0,n_elements(r.id)-1 do begin
		d=sqrt(((ra_deg-r.ra[i])*cos(dec_rad))^2 $
		       +(startable.dec-r.dec[i])^2)
		j=where(d eq min(d)) & j=j[0]
		if min(d) lt 0.5/3600 then begin
			bad_index[j]=1
		endif
	endfor
	startable=startable[where(bad_index eq 0)]
endif
;
end
