pro get_leeuwen
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read new Hipparcos reduction by Leeuwen
; http://cdsarc.u-strasbg.fr/viz-bin/Cat?I/311
;
common StarBase,startable,notes
;
index=where(startable.px ne 0,p_count1)
;
xdr_file=!oyster_dir+'catalogs/leeuwen/hip2.xdr'
f=file_search(xdr_file) & f=f[0]
;
if strlen(f) eq 0 then begin
;
	dat_file=!oyster_dir+'catalogs/leeuwen/hip2.dat'
	f=file_search(dat_file) & f=f[0]
	openr,unit,dat_file,/get_lun,error=status
	if status ne 0 then begin
		print,'***Error(GET_LEEUWEN): error opening file ',dat_file,'!'
		return
	endif
	n=117955
	hip=lonarr(n)
	px=fltarr(n)
	pxe=fltarr(n)
	for i=0l,n-1 do begin
		readf,unit,id,sn,so,nc,ra,dec,plx,pmra,pmdec,rae,dece,plxe
		hip[i]=id
		px[i]=plx
		pxe[i]=plxe
	endfor
	px=px/1000
	pxe=pxe/1000
	save,hip,px,pxe,file=xdr_file
;
endif else restore,xdr_file
;
index=where(startable.hic ne 0,count)
if count gt 0 then begin
	plx=startable[index].px
	plxe=startable[index].pxe
	hic=startable[index].hic
;
	for i=0,count-1 do begin
		j=where(hip eq hic[i],j_count)
		if j_count gt 0 then begin
			plx[i]=px[j[0]]
			plxe[i]=pxe[j[0]]
		endif
	endfor
	startable[index].px=plx
	startable[index].pxe=plxe
;
	index=where(startable.px ne 0,p_count2)
	print,'Number of parallaxes increased by: ',p_count2-p_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_LEEUWEN): No stars with HIC name found!'
;
end
