pro get_logg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Cayrel de Strobel (1985) gravity data in
; catalogs/npoi/logg.hdn.
; Note: data will replace current non-zero values!
;
common StarBase,startable,notes
;
index=where(startable.logg1 ne 0,logg_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	logg1=startable[index].logg1
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/logg.hdn', $
		n,logg,/col,ignore=['!'])
;
	for i=0L,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			logg1[i]=logg[j[0]]
		endif
	endfor
	startable[index].logg1=logg1
;
	index=where(startable.logg1 ne 0,logg_count2)
	print,'Number of new gravity values found: ',logg_count2-logg_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_LOGG): No stars with HDN name found!'
;
end
