pro get_m12
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read 12 micron fluxes from the MDFC catalog (Cruzalebes et al. 2019)
;
common StarBase,startable,notes
;
; Positional precision ["] of OYSTER HDN catalog
precision=1.0
;
; Get name of latest FITS file for MDFC
mdfc_fits=file_search(!oyster_dir+'starbase/MDFC/mdfc-v??.fits')
if strlen(mdfc_fits[0]) eq 0 then begin
	print,'Error(GET_MDFC): FITS file not found!'
	return
endif
; Use latest version
mdfc_fits=mdfc_fits[n_elements(mdfc_fits)-1]
;
d=mrdfits(mdfc_fits,1,header,/silent)
ra=hms2h(d.raj2000)
dec=dms2d(d.dej2000)
;
; Try to find each star of startable in catalog by coordinates
for i=0L,n_elements(startable)-1 do begin
	angles=winkel(startable[i].ra,startable[i].dec,ra,dec)
	print,min(angles)*3600
	j=where(angles eq min(angles))
	if angles[j]*3600 lt precision then startable[i].f12=d[j].med_nflux
endfor
;
end
