pro get_mark3data,file,status
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read MarkIII .cal file.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
common ModelFit,parameters,ds_options
;
; Note: except for a header line containing date, baseline number, and the
; three channel wavelengths (all numbers), Mark III .cal files consist of
; eleven columns of numeric data.
;
SystemId='Mark3'
;
; Mark III filter configurations
n_config=13
waves=[ $
[ 486.0,                486.0,                486.0], $
[ 656.0,                656.0,                550.0], $
[ 657.0,                656.0,                550.0], $
[ 700.0,                450.2,                550.0], $
[ 754.0,                623.0,                712.0], $
[ 799.2,                450.2,                550.1], $
[ 800.0,                450.2,                500.0], $
[ 800.0,                450.2,                550.0], $
[ 800.0,                451.8,                500.0], $
[ 800.0,                500.0,                550.0], $
[ 800.0,                500.0,                656.0], $
[ 800.0,                500.1,                550.0], $
[ 800.0,                656.0,                550.0]]
combinerids=indgen(n_config)
;
openr,unit,file,/get_lun,error=status
if status ne 0 then begin
	print,'***Error(GET_MARK3DATA): error opening file ',file,'!'
	return
endif
;
; Read header line with date, baseline, and wavelength information
mark3_ch1=700.0
readf,unit,mark3_date,mark3_baseline,mark3_ch2,mark3_ch3,mark3_ch4
;
max_scan=300
time=dblarr(max_scan)
mark3_stars=intarr(max_scan)
v2=fltarr(max_scan)
vc2=fltarr(max_scan)
vce2=fltarr(max_scan)
v3=fltarr(max_scan)
vc3=fltarr(max_scan)
vce3=fltarr(max_scan)
v4=fltarr(max_scan)
vc4=fltarr(max_scan)
vce4=fltarr(max_scan)
i=0
while not eof(unit) do begin
	readf,unit,t,id,d2,dc2,dce2,d3,dc3,dce3,d4,dc4,dce4
;	FK5 1817 is not a known star, and FK5 2001 is Nova Cygni
	if id ne 1817 and id ne 2001 then begin
	time[i]=t
	mark3_stars[i]=id
	v2[i]=d2
	vc2[i]=dc2
	vce2[i]=dce2
	v3[i]=d3
	vc3[i]=dc3
	vce3[i]=dce3
	v4[i]=d4
	vc4[i]=dc4
	vce4[i]=dce4
	i=i+1
	endif else print,'Warning: FK5 1817 and 2001 cannot be converted!'
endwhile
num_scan=i
free_lun,unit
;
parsemark3,mark3_date,y,m,d
Date=constrictordate(y,m,d)
;
NumSid=2
NumOutBeam=2
maxBaseline=1
maxSpecChan=2
maxNumTriple=10
maxConfig=1
GenConfig=allocgenconfig(NumSid,NumOutBeam,maxNumTriple, $
	maxBaseline,maxSpecChan,maxConfig)
;
; if abs(mark3_ch3-450) lt 2 then GenConfig.BeamCombinerId=1 $
;			   else GenConfig.BeamCombinerId=2
d=total(abs(waves-[mark3_ch2,mark3_ch3,mark3_ch4]#(fltarr(n_config)+1)),1)
; Zeta Aur data have slightly different w.l. so we don't look for d=0
index=where(d eq min(d) and d le 5,count)
if count eq 0 then begin
	print,'***Error(GET_MARK3DATA): unknown channel configuration!'
	status=-1
	return
endif
GenConfig.BeamCombinerId=combinerids[index]
;
GenConfig.Date=Date
GenConfig.NumSid=NumSid
GenConfig.Diameter=0.05
GenConfig.NumOutBeam=NumOutBeam
GenConfig.NumBaseline=[1,1]
GenConfig.NumSpecChan=[2,2]
GenConfig.refstation=1
;
GenConfig.Wavelength[0,0]=mark3_ch1/1.d9
GenConfig.Wavelength[0,1]=mark3_ch2/1.d9
GenConfig.Wavelength[1,0]=mark3_ch3/1.d9
GenConfig.Wavelength[1,1]=mark3_ch4/1.d9
;
GenConfig.ChanWidth[0,0]=25.0/1.d9
GenConfig.ChanWidth[0,1]=25.0/1.d9
GenConfig.ChanWidth[1,0]=25.0/1.d9
GenConfig.ChanWidth[1,1]=25.0/1.d9
;
GenConfig.BaselineId[0,0]=mark3_baselines[mark3_baseline-1]
GenConfig.BaselineId[0,1]=mark3_baselines[mark3_baseline-1]
GenConfig.StationId[0]=strmid(GenConfig.BaselineId[0,0],0,3)
GenConfig.StationId[1]=strmid(GenConfig.BaselineId[0,1],4,3)
;
; Prepare star IDs
stars='FKV'+string(mark3_stars,format='(i4.4)')
; Replace Mark3 FKV numbers >= 1700 <= 2000 with corresponding BSC numbers
for i=0,n_elements(mark3_cat)-1 do begin
	index=where(stars eq mark3_cat[i],count)
	if count gt 0 then stars[index]=mark3_bsc[i]
endfor
;
scans=replicate(scan(),num_scan)
scans.iscan=indgen(num_scan)+1
scans.starid=stars[0:num_scan-1]
scans.time=time[0:num_scan-1]*3600
scans.int_time=75	; standard scan length, not stored in CAL file
;
scans.VisSq[1,0,0]=v2[0:num_scan-1]
scans.VisSqC[1,0,0]=vc2[0:num_scan-1]
index=where(vc2 eq 2.0,count)
if count gt 0 then vce2[index]=-2
scans.VisSqErr[1,0,0]=vce2[0:num_scan-1]
scans.VisSqCErr[1,0,0]=vce2[0:num_scan-1]
;
scans.VisSq[0,1,0]=v3[0:num_scan-1]
scans.VisSqC[0,1,0]=vc3[0:num_scan-1]
index=where(vc3 eq 2.0,count)
if count gt 0 then vce3[index]=-2
scans.VisSqErr[0,1,0]=vce3[0:num_scan-1]
scans.VisSqCErr[0,1,0]=vce3[0:num_scan-1]
;
scans.VisSq[1,1,0]=v4[0:num_scan-1]
scans.VisSqC[1,1,0]=vc4[0:num_scan-1]
index=where(vc4 eq 2.0,count)
if count gt 0 then vce4[index]=-2
scans.VisSqErr[1,1,0]=vce4[0:num_scan-1]
scans.VisSqCErr[1,1,0]=vce4[0:num_scan-1]
;
print,'ScanData read.'
;
; Create ScanTable
Iscan=lindgen(num_scan)+1	; Attention: First scan has ID 1!
ScanId=lindgen(num_scan)	; ScanId of embedded system
StartTime=dblarr(num_scan)+scans.time-abs(scans.int_time)/2
StopTime=dblarr(num_scan)+scans.time+abs(scans.int_time)/2
NumCoh=lonarr(num_scan)
NumIncoh=lonarr(num_scan)
NumPoint=lonarr(num_scan)
Code=lonarr(num_scan)+1
Station=intarr(6,num_scan)+1
StarId=scans.starid
;
MaxSid=2
ScanTable=build_scantable(Iscan,ScanId,StarId,Code,Station, $
			StartTime,StopTime,NumPoint, $
			NumCoh,NumIncoh)
;
print,'Scantable created.'
;
get_startable
get_stationtable
get_geoparms
calcastrom
;
freememory
GenInfo=replicate(GenConfig,1)
GeoInfo=replicate(GeoParms,1)
;
if n_elements(ds_options) eq 0 then ds_options=alloc_ds_options()
ds_options.i=1	; True: interferometry loaded
ds_options.v2=1
ds_options.ta=0
ds_options.tp=0
;
end
