pro get_mdfc,init=init
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read L-band and 12 micron fluxes from the MDFC catalog
; (Cruzalebes et al. 2019)
;
common StarBase,startable,notes
common get_mdfc_local,mdfc_data
;
if n_elements(init) eq 0 then init=0
;
; Positional precision ["] of OYSTER HDN catalog
precision=1.0
;
; Find latest version and read it
if n_elements(mdfc_data) eq 0 then begin
; 	Get name of latest FITS file for MDFC
	mdfc_fits=file_search(!oyster_dir+'starbase/MDFC/mdfc-v??.fits')
	if strlen(mdfc_fits[0]) eq 0 then begin
		print,'Error(GET_MDFC): FITS file not found!'
		return
	endif
; 	Use latest version
	mdfc_fits=mdfc_fits[n_elements(mdfc_fits)-1]
;
	mdfc_data=mrdfits(mdfc_fits,1,header,/silent)
endif
;
; Read entire HDN catalog if no startable exists or init=1
if n_elements(startable) eq 0 or init then get_hdn
;
; Read entire HIP catalog if no startable exists or init=1
; if n_elements(startable) eq 0 or init then get_hip
;
ra=hms2h(mdfc_data.raj2000)
dec=dms2d(mdfc_data.dej2000)
;
; Try to find each star of startable in catalog by coordinates
for i=0L,n_elements(startable)-1 do begin
	angles=winkel(startable[i].ra,startable[i].dec,ra,dec)
	j=where(angles eq min(angles))
	if angles[j]*3600 lt precision then begin
		startable[i].f12=mdfc_data[j].med_nflux
		startable[i].flp=mdfc_data[j].med_lflux
	endif
endfor
;
; The histogramm shows that the precision is about 1" (not checked yet)
; histograph,min_sep,binsize=0.5,min=0,max=10
;
end
