pro get_merand,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read AMBER calibrator list, "merand.hdn", compiled by Merand et al.
; HDN.xdr can be updated (update=1) since not all stars in the Merand list are
; also in SKYCAT used by OYSTER for HDN starids.
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/merand.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	lines=''
	status=dc_read_fixed(!oyster_dir+'starbase/merand.hdn',lines, $
		/col,resize=[1],format='(a800)',ignore=['!'])
	n=n_elements(lines)
	hd=lonarr(n)
	hip=lonarr(n)
	ra_h=intarr(n)
	ra_m=intarr(n)
	ra_s=fltarr(n)
	dec_d=intarr(n)
	dec_m=intarr(n)
	dec_s=fltarr(n)
	plx=fltarr(n)
	eplx=fltarr(n)
	spectrum=strarr(n)
	mb=fltarr(n)
	mv=fltarr(n)
	mj=fltarr(n)
	mh=fltarr(n)
	mk=fltarr(n)
	f12=fltarr(n)
	ld=fltarr(n)
	lde=fltarr(n)
	ud_j=fltarr(n)
	ud_h=fltarr(n)
	ud_k=fltarr(n)
;
	for i=0,n-1 do begin
		hd[i]=long(strmid(lines[i],0,6))
		hip[i]=long(strmid(lines[i],7,6))
		ra_h[i]=fix(strmid(lines[i],14,2))
		ra_m[i]=fix(strmid(lines[i],17,2))
		ra_s[i]=float(strmid(lines[i],20,4))
		dec_d[i]=fix(strcompress(strmid(lines[i],25,3),/remove_all))
		dec_m[i]=fix(strmid(lines[i],29,2))
		dec_s[i]=float(strmid(lines[i],32,4))
		plx[i]=float(strmid(lines[i],37,5))
		eplx[i]=float(strmid(lines[i],44,4))
		spectrum[i]=strmid(lines[i],49,13)
		mb[i]=float(strmid(lines[i],63,4))
		mv[i]=float(strmid(lines[i],68,4))
		mj[i]=float(strmid(lines[i],73,4))
		mh[i]=float(strmid(lines[i],78,4))
		mk[i]=float(strmid(lines[i],83,4))
		f12[i]=float(strmid(lines[i],88,4))
		ld[i]=float(strmid(lines[i],93,5))
		lde[i]=float(strmid(lines[i],117,5))
		ud_j[i]=float(strmid(lines[i],99,5))
		ud_h[i]=float(strmid(lines[i],105,5))
		ud_k[i]=float(strmid(lines[i],111,5))
	endfor
;
	for i=0L,count-1 do begin
		j=where(hd eq hdn[i],j_count)
		if j_count gt 0 then begin
			startable[i].diameter=ud_k[j]
;			startable(i).diametere=lde(j)
			startable[i].mv=mv[j]
			startable[i].mj=mj[j]
			startable[i].mh=mh[j]
			startable[i].mk=mk[j]
			startable[i].f12=f12[j]
			startable[i].bflag='C'
		endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameter values found: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_MERAND): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
