pro get_metrodata
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Load metrology data from CONSTRICTOR output. These data are found in the
; METRODATA object both in .inch and .con files. These are raw data.
;
common MetroData,fbairtemp,fbsolidtmp
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([8,21]) ne 0 then return
numsid=genconfig.numsid
;
if hds_state() eq 0 then begin
        print,'***Error(GET_METRODATA): no HDS file open!'
        return
endif
toplevel
;
name='metrodata'
dat_there,name,reply
if not reply then return
dat_find,name
;
; Get FB (feed beam) data
dat_find,'fbairtempdata',status
if status eq 0 then begin
num=intarr(genconfig.numsid)
for i=0,numsid-1 do begin
	dat_cell,1,i+1
	get_object,'numdata',n
	num[i]=n
	dat_annul
endfor
fbairtemp={numdata:num,timestamp:fltarr(max(num),numsid), $
	data:fltarr(max(num),max(metroconfig.fbairtemp.numsensor),numsid), $
	error:fltarr(max(num),max(metroconfig.fbairtemp.numsensor),numsid)+0.1}
for i=0,numsid-1 do begin
        dat_cell,1,i+1
        get_object,'data',d
        get_object,'timestamp',t
        dat_annul
        fbairtemp.data[0:fbairtemp.numdata[i]-1,*,i]=float(d)/100
        fbairtemp.timestamp[0:fbairtemp.numdata[i]-1,i]=float(t)/3600000
endfor
dat_annul
endif
;
dat_find,'fbsolidtmpdata',status
if status eq 0 then begin
num=intarr(genconfig.numsid)
for i=0,numsid-1 do begin
	dat_cell,1,i+1
	get_object,'numdata',n
	num[i]=n
	dat_annul
endfor
fbsolidtmp={numdata:num,timestamp:fltarr(max(num),numsid), $
	data:fltarr(max(num),max(metroconfig.fbsolidtmp.numsensor),numsid), $
	error:fltarr(max(num),max(metroconfig.fbsolidtmp.numsensor),numsid)+0.1}
for i=0,numsid-1 do begin
        dat_cell,1,i+1
        get_object,'data',d
        get_object,'timestamp',t
        dat_annul
        fbsolidtmp.data[0:fbsolidtmp.numdata[i]-1,*,i]=float(transpose(d))/100
        fbsolidtmp.timestamp[0:fbsolidtmp.numdata[i]-1,i]=float(t)/3600000l
endfor
dat_annul
endif
;
toplevel
;
end
