pro get_motiongroup,motiongroup
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From INCHWORM output file (.inch), read solution #motiongroup.
;
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if hds_state() eq 0 then begin
        print,'***Error(GET_MOTIONGROUP): no HDS file open!'
        return
endif
toplevel
;
; Check if MetroConfig is present
if checkdata([21]) ne 0 then return
;
get_format,format
if format ne 'INCHWORM' then begin
	print,'***Error(GET_MOTIONGROUP): not an INCHWORM file!'
	return
endif
;
if n_elements(motiongroup) eq 0 then motiongroup=1
;
get_nummotiongroup,n
if n lt motiongroup then begin
	print,'***Error(GET_MOTIONGROUP): only ',n,' groups!'
	return
endif
;
; Load corresponding avegroup first
dat_find,'MOTIONGROUP'
vdim=1L
dat_cell,vdim,motiongroup
cmp_get0i,'AVEGROUP',avegroup
dat_annul
dat_annul
get_avegroup,avegroup
numtime=n_elements(MetroTime)
;
; Get info on which siderostat corresponds to which plate
dat_find,'GENCONFIG'
cmp_get0i,'NUMPLATE',numplate
plateid=intarr(numplate)
dat_find,'PLATE'
vdim=1L
for i=1,numplate do begin
	dat_cell,vdim,i
	cmp_get0i,'PLATEEMBEDDED',n
	plateid[i-1]=n
	dat_annul
endfor
dat_annul
dat_annul
nsd=max(plateid)
if nsd lt GenConfig.NumSid then begin
	print,'Warning(GET_MOTIONGROUP): fewer plates than siderostats!'
endif
;
dat_find,'MOTIONGROUP'
dat_cell,vdim,motiongroup
dat_find,'SIDEROSTAT'
dat_shape,ndim,dims
NumPlate=dims[0]
flag=0
if ndim ne 1 then flag=1
if flag then begin
    print,'***Error(GET_MOTIONGROUP): Object SIDEROSTAT with wrong dimensions'
    toplevel
    return
endif
;
pidx=MetroConfig.PlateIdx
for i=1L,NumPlate do begin
	dat_cell,vdim,i
	dat_there,'PAR',reply
	if reply eq 1 and pidx[plateid[i-1]-1] ne -1 then begin
		cmp_get0i,'NUMPAR',numpar
		ndim=2
		dims[0]=numpar
		dims[1]=numtime
		cmp_getnd,'PAR',ndim,dims,v
		ParX[pidx[plateid[i-1]-1],*]=v[0,*]
		ParY[pidx[plateid[i-1]-1],*]=v[1,*]
		ParZ[pidx[plateid[i-1]-1],*]=v[2,*]
		cmp_getnd,'PARERR',ndim,dims,v
		index=where(v[0,*] eq 0,count)
		if count gt 0 then v[0,index]=-1
		ParXErr[pidx[plateid[i-1]-1],*]=v[0,*]
		index=where(v[1,*] eq 0,count)
		if count gt 0 then v[1,index]=-1
		ParYErr[pidx[plateid[i-1]-1],*]=v[1,*]
		index=where(v[2,*] eq 0,count)
		if count gt 0 then v[2,index]=-1
		ParZErr[pidx[plateid[i-1]-1],*]=v[2,*]
		index=where(MotorAngleErr[0,pidx[plateid[i-1]-1],*] lt 0,count)
		if count gt 0 then begin
			ParXErr[pidx[plateid[i-1]-1],index]=-1
			ParYErr[pidx[plateid[i-1]-1],index]=-1
			ParZErr[pidx[plateid[i-1]-1],index]=-1
		endif
	endif
	dat_annul
endfor
;
toplevel
print,'Motion group loaded.'
;
end
