pro get_n12
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read color-uncorrected IRAS 12 micron fluxes, which for normal stars are
; close to the actual fluxes in the N band.
;
common StarBase,startable,notes
;
files=file_search(!oyster_dir+'starbase/n.bsc') & files=files[0]
if strlen(files) eq 0 then begin
n=''
s=dc_read_fixed(!oyster_dir+'starbase/n.dat',n,/col,ignore=['!'],format='(a120)'
;
index=where(strmid(n,10,10) eq '----------',count)
bsc=intarr(count)
d=fltarr(count)
f12=fltarr(count)
;
dummy='   '
hr=0
r=0.
f=0.
for i=0,count-1 do begin
	reads,n[index[i]-3],dummy,hr,format='(35x,a3,i5)'
	bsc[i]=hr
	reads,n[index[i]-1],r,f,format='(8x,f5.3,62x,e8.2)'
	d[i]=r
	f12[i]=f
endfor
;
; index=where(d lt 0.1,count)
; bsc=bsc(index)
; f12=f12(index)
openw,unit,!oyster_dir+'starbase/n.bsc',/get_lun
printf,unit,'! IRAS 12 micron fluxes in Jansky'
printf,unit,'! Data are retrieved from VizieR-4,'
printf,unit,'! IRAS point sources within 6 arcseconds'
printf,unit,'! or target position.'
for i=0,count-1 do printf,unit,bsc[i],f12[i]
free_lun,unit
endif
;
index=where(startable.f12 ne 0,f12_count1)
;
index=where(startable.bsc ne 0,count)
if count gt 0 then begin
	f12=startable[index].f12
	bsc=startable[index].bsc
	status=dc_read_free(!oyster_dir+'starbase/n.bsc', $
		n,f_12,/col,ignore=['!'])
;
	for i=0,count-1 do begin
		j=where(n eq bsc[i],j_count)
		if j_count gt 0 then begin
			f12[i]=f_12[j[0]]
		endif
	endfor
	startable[index].f12=f12
;
	index=where(startable.f12 ne 0,f12_count2)
	print,'Number of new F12 values found: ',f12_count2-f12_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_F12): No stars with BSC name found!'
;
end
