pro get_natcounts,natcounts,Iscan_ids,rec0=rec0,recn=recn
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure may serve as a template
; for procedures loading individual HDS object from NPOI data files.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([1,8]) ne 0 then return
;
if hds_state() eq 0 then begin
	print,'***Error(GET_NATCOUNTS): no HDS file open!'
	return
endif
toplevel
;
get_format,format
if format eq 'CHAMELEON' then begin
	print,'***Error(GET_NATCOUNTS): wrong file format!'
	return
endif
;
if n_elements(Iscan_ids) eq 0 then Iscan_ids=indgen(n_elements(ScanTable))+1
scan_ids=Iscan_ids-1	; scan_ids used to address arrays, which start at 0!
num_scans=n_elements(scan_ids)	; This is the number of scans to be loaded
;
; Find out about the total number of points: MP
MP=long(total(ScanTable[scan_ids].NumPoint))
if MP eq 0 then begin
	print,'Warning(GET_NATCOUNTS): no valid data points found.'
	return
endif
;
; Allocate arrays
natcounts=fltarr(genconfig.numsid,MP,/nozero)
;
rec0=intarr(num_scans)
recn=intarr(num_scans)-1
;
; Get data
for i=0,num_scans-1 do begin
	numpoint=scantable[scan_ids[i]].numpoint
	recn[i]=max(recn)+numpoint
	rec0[i]=recn[i]-numpoint+1
for j=0,GenConfig.NumSid-1 do begin
	get_object,'SCANDATA.POINTDATA('+string(scan_ids[i]+1)+').INPUTBEAM('+string(ge
	NatCounts[j,rec0[i]:recn[i]]=c
endfor
endfor
toplevel
;
end
