pro get_object,path,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Direct loading of primitive object with given path, e.g.
; path='SCANDATA.POINTDATA(1).INPUTBEAM(2).FDLPOS'.
; Allocation of v is automatic.
;
path=strupcase(path)
;
il=0
i1=0
i2=strpos(path,'.',i1)
while i2 ne -1 do begin
	name=strmid(path,i1,i2-i1)
	j1=strpos(name,'(',0)
	if j1 ne -1 then begin
		dat_find,strmid(name,0,j1),status
		if status ne 0 then goto,cleanup
		il=il+1
		j2=strpos(name,')',0)
		cell=stringparse(strmid(name,j1+1,j2-j1-1))
		vdim=n_elements(cell)
		dat_cell,vdim,cell,status
		if status ne 0 then goto,cleanup
		il=il+1
	endif else begin
		dat_find,name,status
		if status ne 0 then goto,cleanup
		il=il+1
	endelse
	i1=i2+1
	i2=strpos(path,'.',i1)
endwhile
dat_find,strmid(path,i1,strlen(path)-i1),status
if status ne 0 then goto,cleanup
il=il+1
;
dat_prim,reply
if reply ne 1 then begin
	print,'***Error(GET_OBJECT): object not primitive!'
	goto,cleanup
endif
dat_type,type & type=strcompress(type,/remove_all)
dat_shape,ndim,dims
dat_get,type,ndim,dims,v
;
cleanup:
for i=1,il do dat_annul
;
end
