pro get_oitarget,fitsfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read just revision 2 OI_TARGET binary table from OIFITS file.
;
common Tables,ScanTable,BGTable,StationTable
common StarBase,StarTable,Notes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(fitsfile) eq 0 then fitsfile='oitarget.fits'
files=file_search(fitsfile)
if strlen(files[0]) eq 0 then begin
	print,'***Error(GET_OITARGET): file not found!'
	return
endif
;
read_oidata,fitsfile,oiarray,oitarget,oiwavelength,oivis,oivis2,oit3,/inventory
;
; Assemble startable
if n_elements(oitarget) eq 0 then begin
	starid=''
	read,starid, $
	prompt='Target table not present, please enter star ID [HDN123456]: ', $
	get_startable,starid
endif else begin
	targets=strcompress(oitarget.target,/remove_all)
	create_startable,targets
	startable.name=targets
	startable.ra=oitarget[*].raep0/15
	startable.dec=oitarget[*].decep0
	startable.rae=oitarget[*].ra_err
	startable.dece=oitarget[*].dec_err
	startable.rv=oitarget[*].sysvel
	startable.pmra=oitarget[*].pmra
	startable.pmdec=oitarget[*].pmdec
	startable.pmrae=oitarget[*].pmra_err
	startable.pmdece=oitarget[*].pmdec_err
	startable.px=oitarget[*].parallax
	startable.pxe=oitarget[*].para_err
	startable.spectrum=oitarget[*].spectyp
	startable_id=intarr(max(oitarget.target_id)+1)
	for i=0,n_elements(startable)-1 do begin
		startable_id[oitarget[i].target_id]=i
		if valid_cat(targets[i]) eq 1 then starid=targets[i] $
					      else starid=cri_vlti(targets[i])
		if strlen(starid) eq 0 then begin
			startable[i].starid='OBJ'+esoid(startable[i].ra, $
							startable[i].dec)
		endif else begin
			startable[i].starid=starid
		endelse
	endfor
; 	Update for OI_TARGET revision 2
	startable.diameter=oitarget[*].diameter
	startable.omega=oitarget[*].omega
	startable.vsini=oitarget[*].vsini
	startable.tilt=oitarget[*].tilt
	startable.rapa=oitarget[*].rapa
	startable.mass=oitarget[*].mass
	startable.teff=oitarget[*].teff
	startable.logg=oitarget[*].logg
	startable.zexp=oitarget[*].zexp
	for i=0,n_elements(startable)-1 do begin
		startable[i].sed=*oitarget[i].flux
		startable[i].wvl=*oitarget[i].wave
		startable[i].img=*oitarget[i].img
	endfor
;
	read_catalogs	; We had a case with bad coordinates in the OIFITS file
endelse
;
end
