pro get_opddata,opslog
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Open a VLTI/WDLINE ops.log file with OPD measurements and read it,
; storing the values in the existing scans structure.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
l=''
status=dc_read_fixed(opslog,l,/col,format='(a300)')
index=where(strpos(l,'POM MEASURE') ge 0 and strpos(l,'J 2000') ge 0,count)
if count eq 0 then begin
	print,'***Error(GET_WDLINEDATA): no POM data'
	return
endif
l=l[index]
n=count
;
ra=fltarr(n)
dec=fltarr(n)
config=strarr(n)
dates=strarr(n)
times=fltarr(n)
delay=fltarr(n,2)
;
for k=0,n-1 do begin
	i0=strpos(l[k],'MEASURE')
	i1=strpos(l[k],'/')
	command=strmid(l[k],i0,i1-i0)
	r=execute(command)
	w=nameparse(measure)
	config[k]=strmid(w[0],0,23)
	ra[k]=float(w[1])+float(w[2])/60+float(w[3])/3600
	dec[k]=abs(float(w[4]))+float(w[5])/60+float(w[6])/3600
	if strmid(w[4],0,1) eq '-' then dec[k]=-dec[k]
	dates[k]=w[13]+'-'+w[14]+'-'+w[15]
	times[k]=float(w[16])+float(w[17])/60+float(w[18])/3600
	delay[k,0]=float(w[19])	; Delay of dl1
	delay[k,1]=float(w[20])	; Delay of dl2
endfor
;
if checkdate() ne date then begin
	index=where(times lt 12)
	times[index]=times[index]+24
endif
;
index=where(strpos(config,'-dl') ge 0,count)
if count eq 0 then begin
	print,'***Error(GET_WDLINEDATA): no valid configurations found!'
	return
endif
config=config[index]
uconfig=unique(config)
print,'Found configurations: ',uconfig
index=where(times ge scans[0].time/3600 $
	and times le scans[n_elements(scans)-1].time/3600)
config=unique(config[index])
config=config[0]
print,'Using configuration: ',config
; UTs and ATs generate different config strings
dl1=fix(strmid(config,2,1))
dl2=fix(strmid(config,2+12,1))
ic1=fix(strmid(config,10,1))
ic2=fix(strmid(config,10+12,1))
if strmid(config,3,1) eq 'U' then begin
	s1=strmid(config,3,3)
	s2=strmid(config,15,3)
endif else begin
	s1=strmid(config,3,1)+strmid(config,6,2)
	s2=strmid(config,15,1)+strmid(config,18,2)
endelse
;
for i=0,n_elements(scans)-1 do begin
	dra=abs(ra-scans[i].ra)*15
	ddec=abs(dec-scans[i].dec)
	dt=abs(times-scans[i].time/3600)*15
	d=sqrt(dra^2+ddec^2+dt^2)
	index=where(dt eq min(dt))
	delay1=delay[index,0]
	delay2=delay[index,1]
;	if genconfig.refstation eq 1 then delay2=delay2-delay1 $
;				     else delay1=delay1-delay2
	j=where(genconfig.stationid eq s1)
	scans[i].fdlpos(j)=delay1
	j=where(genconfig.stationid eq s2)
	scans[i].fdlpos(j)=delay2
	scans[i].time=times[index]*3600
;
;	The position in scans is the apparent position
	scans[i].ra=ra[index]
	scans[i].dec=dec[index]
endfor
;
if genconfig.refstation eq 1 $
	then scans.fdlpos[1]=scans.fdlpos[1]-scans.fdlpos[0] $
	else scans.fdlpos[0]=scans.fdlpos[0]-scans.fdlpos[1]
;
end
;
