pro get_opdmodel,opdmodel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read VLTI format OPD model
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
dl1=fix(strmid(opdmodel,2,1))
dl2=fix(strmid(opdmodel,2+12,1))
ic1=fix(strmid(opdmodel,10,1))
ic2=fix(strmid(opdmodel,10+12,1))
if strmid(opdmodel,3,1) eq 'U' then begin
	s1=strmid(opdmodel,3,3)
	s2=strmid(opdmodel,15,3)
endif else begin
	s1=strmid(opdmodel,3,1)+strmid(opdmodel,6,2)
	s2=strmid(opdmodel,15,1)+strmid(opdmodel,18,2)
endelse
;
l=''
status=dc_read_fixed(opdmodel,l,/col,format='(a300)')
;
i=strpos(l,'T1X') & j=where(i ge 0) & j=j[0]
words=nameparse(l[j])
t1x=double(words[1])
;
i=strpos(l,'T1Y') & j=where(i ge 0) & j=j[0]
words=nameparse(l[j])
t1y=double(words[1])
;
i=strpos(l,'T1Z') & j=where(i ge 0) & j=j[0]
words=nameparse(l[j])
t1z=double(words[1])
;
i=strpos(l,'A1L') & j=where(i ge 0) & j=j[0]
words=nameparse(l[j])
a1l=-double(words[1])
;
genconfig.stationcoord[*,0]=[t1x,t1y,t1z,a1l]/1d6
genconfig.stationcoord[*,1]=[t1x,t1y,t1z,a1l]/1d6
if s1 ne genconfig.stationid[genconfig.refstation-1] then $
	genconfig.stationcoord=-genconfig.stationcoord
genconfig.stationcoord[*,genconfig.refstation-1]=0
;
end
