pro get_parallax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Yale (1991) parallaxes in starbase/parallax.hdn.
; Note: data found will replace current values!
;
common StarBase,startable,notes
;
index=where(startable.px ne 0,p_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	px=startable[index].px
	pxe=startable[index].pxe
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/parallax.hdn', $
		n,p,pe,/col,ignore=['!'])
;
	for i=0,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			px[i]=p[j[0]]
			pxe[i]=pe[j[0]]
		endif
	endfor
	startable[index].px=px
	startable[index].pxe=pxe
;
	index=where(startable.px ne 0,p_count2)
	print,'Number of parallaxes increased by: ',p_count2-p_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_PARALLAX): No stars with HDN name found!'
;
end
